/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.io.FilePaths;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

class ProjectFinder {
    private static final Key<CopyOnWriteArrayList<Project>> NEW_PROJECTS_KEY = Key.create((String)"idea.gradle.sync.new.projects");

    ProjectFinder() {
    }

    static void registerAsNewProject(@NotNull Project project) {
        CopyOnWriteArrayList<Object> newProjects = ProjectFinder.getNewProjects();
        if (newProjects == null) {
            newProjects = new CopyOnWriteArrayList();
            ApplicationManager.getApplication().putUserData(NEW_PROJECTS_KEY, newProjects);
        }
        newProjects.addIfAbsent(project);
    }

    static void unregisterAsNewProject(@NotNull Project project) {
        Application application = ApplicationManager.getApplication();
        CopyOnWriteArrayList newProjects = (CopyOnWriteArrayList)application.getUserData(NEW_PROJECTS_KEY);
        if (newProjects != null) {
            newProjects.remove(project);
        }
    }

    @Nullable
    Project findProject(@NotNull ProjectResolverContext context) {
        String projectPath = context.getProjectPath();
        if (StringUtil.isNotEmpty((String)projectPath)) {
            File projectFolderPath = FilePaths.toSystemDependentPath((String)projectPath);
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                if (!ProjectFinder.hasMatchingPath(project, projectFolderPath)) continue;
                return project;
            }
            CopyOnWriteArrayList<Project> newProjects = ProjectFinder.getNewProjects();
            if (newProjects != null) {
                for (Project project : newProjects) {
                    if (!ProjectFinder.hasMatchingPath(project, projectFolderPath)) continue;
                    return project;
                }
            }
        }
        return null;
    }

    private static boolean hasMatchingPath(@NotNull Project project, @NotNull File path) {
        File currentPath;
        String basePath = project.getBasePath();
        return basePath != null && FileUtil.filesEqual((File)path, (File)(currentPath = new File(basePath)));
    }

    @Nullable
    private static CopyOnWriteArrayList<Project> getNewProjects() {
        return (CopyOnWriteArrayList)ApplicationManager.getApplication().getUserData(NEW_PROJECTS_KEY);
    }
}

