/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectImportErrorHandler;

public class ProjectImportErrorHandler
extends AbstractProjectImportErrorHandler {
    private static final Pattern ERROR_LOCATION_PATTERN = Pattern.compile(".* file '(.*)'( line: ([\\d]+))?");

    @Nullable
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        Pair<String, Integer> pair;
        if (error instanceof ExternalSystemException) {
            this.logSyncFailure(null);
            return (ExternalSystemException)error;
        }
        Pair rootCauseAndLocation = this.getRootCauseAndLocation(error);
        Throwable rootCause = (Throwable)rootCauseAndLocation.getFirst();
        String location = (String)rootCauseAndLocation.getSecond();
        String errMessage = ProjectImportErrorHandler.createErrorMessage(rootCause);
        ExternalSystemException exception = null;
        if (StringUtil.isNotEmpty((String)location) && (pair = ProjectImportErrorHandler.getErrorLocation(location)) != null) {
            exception = new LocationAwareExternalSystemException(errMessage, (String)pair.first, (Integer)pair.getSecond(), new String[0]);
        }
        if (exception == null) {
            exception = new ExternalSystemException(errMessage);
        }
        exception.initCause(rootCause);
        return exception;
    }

    public void logSyncFailure(@Nullable Project project) {
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
        event.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE_DETAILS).setGradleSyncFailure(AndroidStudioEvent.GradleSyncFailure.UNKNOWN_GRADLE_FAILURE);
        UsageTrackerUtils.withProjectId(event, project);
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    @NotNull
    public static String createErrorMessage(@NotNull Throwable rootCause) {
        String errMessage = rootCause.getMessage();
        if (StringUtil.isEmpty((String)errMessage)) {
            errMessage = Throwables.getStackTraceAsString((Throwable)rootCause);
        }
        if (Character.isLowerCase(errMessage.charAt(0))) {
            errMessage = "Cause: " + errMessage;
        }
        return errMessage;
    }

    @Nullable
    public String getLocationFrom(@NotNull Throwable error) {
        String location;
        String errorToString = error.toString();
        if (errorToString.contains("LocationAwareException") && (location = error.getMessage()) != null && (location.startsWith("Build file '") || location.startsWith("Settings file '"))) {
            String[] lines = StringUtil.splitByLines((String)location);
            return lines.length > 0 ? lines[0] : null;
        }
        return null;
    }

    @NotNull
    public ExternalSystemException createUserFriendlyError(@NotNull String msg, @Nullable String location, String ... quickFixes) {
        Pair<String, Integer> pair;
        if (StringUtil.isNotEmpty((String)location) && (pair = ProjectImportErrorHandler.getErrorLocation(location)) != null) {
            return new LocationAwareExternalSystemException(msg, (String)pair.first, (Integer)pair.getSecond(), quickFixes);
        }
        return new ExternalSystemException(msg, null, quickFixes);
    }

    @VisibleForTesting
    @Nullable
    static Pair<String, Integer> getErrorLocation(@NotNull String location) {
        Matcher matcher = ERROR_LOCATION_PATTERN.matcher(location);
        if (matcher.matches()) {
            String filePath = matcher.group(1);
            int line = -1;
            String lineAsText = matcher.group(3);
            if (lineAsText != null) {
                try {
                    line = Integer.parseInt(lineAsText);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return Pair.create((Object)filePath, (Object)line);
        }
        return null;
    }
}

