/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectBuildFileChecksums;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.idea.IdeaSyncPopulateProjectTask;
import com.android.tools.idea.gradle.project.sync.idea.ProjectFinder;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectSetUpTask
implements ExternalProjectRefreshCallback {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PostSyncProjectSetup.Request mySetupRequest;
    @Nullable
    private final GradleSyncListener mySyncListener;
    private final boolean mySyncSkipped;

    ProjectSetUpTask(@NotNull Project project, @NotNull PostSyncProjectSetup.Request setupRequest, @Nullable GradleSyncListener syncListener, boolean syncSkipped) {
        this.myProject = project;
        this.mySetupRequest = setupRequest;
        this.mySyncListener = syncListener;
        this.mySyncSkipped = syncSkipped;
    }

    public void onSuccess(@NotNull ExternalSystemTaskId taskId, @Nullable DataNode<ProjectData> projectInfo) {
        assert (projectInfo != null);
        ProjectFinder.unregisterAsNewProject(this.myProject);
        if (this.mySyncListener != null) {
            this.mySyncListener.setupStarted(this.myProject);
        }
        GradleSyncState.getInstance(this.myProject).setupStarted();
        boolean importedProject = GradleProjectInfo.getInstance(this.myProject).isImportedProject();
        this.doPopulateProject(projectInfo, taskId);
        Runnable runnable = () -> {
            boolean isTest = ApplicationManager.getApplication().isUnitTestMode();
            if (!isTest || !GradleProjectImporter.ourSkipSetupFromTest) {
                if (importedProject) {
                    GradleProjects.open(this.myProject);
                }
                if (!isTest) {
                    CommandProcessor.getInstance().runUndoTransparentAction(() -> this.myProject.save());
                }
            }
            if (importedProject) {
                AndroidGradleProjectComponent projectComponent = AndroidGradleProjectComponent.getInstance(this.myProject);
                projectComponent.configureGradleProject();
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            TransactionGuard.getInstance().submitTransactionLater((Disposable)this.myProject, runnable);
        }
    }

    private void doPopulateProject(@NotNull DataNode<ProjectData> projectInfo, @NotNull ExternalSystemTaskId taskId) {
        IdeaSyncPopulateProjectTask task = new IdeaSyncPopulateProjectTask(this.myProject);
        task.populateProject(projectInfo, taskId, this.mySetupRequest, () -> {
            if (this.mySyncListener != null) {
                if (this.mySyncSkipped) {
                    this.mySyncListener.syncSkipped(this.myProject);
                } else {
                    this.mySyncListener.syncSucceeded(this.myProject);
                }
            }
        });
    }

    public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
        Logger logger = ProjectSetUpTask.getLogger();
        if (StringUtil.isNotEmpty((String)errorDetails)) {
            logger.warn(errorDetails);
        }
        logger.warn(errorMessage);
        if (errorMessage.contains(ExternalSystemBundle.message((String)"error.resolve.already.running", (Object[])new Object[]{""}))) {
            return;
        }
        ProjectFinder.unregisterAsNewProject(this.myProject);
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (!this.myProject.isDisposed()) {
                ExternalSystemUtil.ensureToolWindowContentInitialized((Project)this.myProject, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID);
            }
        });
        this.handleSyncFailure(errorMessage);
    }

    private void handleSyncFailure(@NotNull String errorMessage) {
        String newMessage = ExternalSystemBundle.message((String)"error.resolve.with.reason", (Object[])new Object[]{errorMessage});
        ProjectBuildFileChecksums.removeFrom(this.myProject);
        GradleSyncState.getInstance(this.myProject).syncFailed(newMessage);
        if (this.mySyncListener != null) {
            this.mySyncListener.syncFailed(this.myProject, newMessage);
        }
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(ProjectSetUpTask.class);
    }
}

