/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class DataNodeCaches {
    @NotNull
    private final Project myProject;

    @NotNull
    public static DataNodeCaches getInstance(@NotNull Project project) {
        return (DataNodeCaches)ServiceManager.getService((Project)project, DataNodeCaches.class);
    }

    public DataNodeCaches(@NotNull Project project) {
        this.myProject = project;
    }

    @Nullable
    public DataNode<ProjectData> getCachedProjectData() {
        ExternalProjectInfo projectInfo = this.getExternalProjectInfo();
        return projectInfo != null ? projectInfo.getExternalProjectStructure() : null;
    }

    @Nullable
    private ExternalProjectInfo getExternalProjectInfo() {
        ProjectDataManager dataManager = ProjectDataManager.getInstance();
        String projectPath = Projects.getBaseDirPath((Project)this.myProject).getPath();
        return dataManager.getExternalProjectData(this.myProject, GradleConstants.SYSTEM_ID, projectPath);
    }

    public boolean isCacheMissingModels(@NotNull DataNode<ProjectData> cache2) {
        Collection moduleDataNodes = ExternalSystemApiUtil.findAll(cache2, (Key)ProjectKeys.MODULE);
        if (!moduleDataNodes.isEmpty()) {
            Map<String, DataNode<ModuleData>> moduleDataNodesByName = DataNodeCaches.indexByModuleName(moduleDataNodes);
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            for (Module module : moduleManager.getModules()) {
                GradleFacet gradleFacet;
                DataNode<ModuleData> moduleDataNode = moduleDataNodesByName.get(module.getName());
                if (!(moduleDataNode == null ? (gradleFacet = GradleFacet.getInstance(module)) != null : DataNodeCaches.isCacheMissingModels(moduleDataNode, module))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<String, DataNode<ModuleData>> indexByModuleName(@NotNull Collection<DataNode<ModuleData>> moduleDataNodes) {
        HashMap mapping = Maps.newHashMap();
        for (DataNode<ModuleData> moduleDataNode : moduleDataNodes) {
            ModuleData data = (ModuleData)moduleDataNode.getData();
            mapping.put(data.getExternalName(), moduleDataNode);
        }
        return mapping;
    }

    private static boolean isCacheMissingModels(@NotNull DataNode<ModuleData> cache2, @NotNull Module module) {
        DataNode ndkModuleModelDataNode;
        NdkFacet ndkFacet;
        GradleFacet gradleFacet = GradleFacet.getInstance(module);
        if (gradleFacet != null) {
            DataNode javaProjectDataNode;
            JavaFacet javaFacet;
            DataNode androidDataNode;
            DataNode gradleDataNode = ExternalSystemApiUtil.find(cache2, AndroidProjectKeys.GRADLE_MODULE_MODEL);
            if (gradleDataNode == null) {
                return true;
            }
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet != null ? (androidDataNode = ExternalSystemApiUtil.find(cache2, AndroidProjectKeys.ANDROID_MODEL)) == null : (javaFacet = JavaFacet.getInstance(module)) != null && (javaProjectDataNode = ExternalSystemApiUtil.find(cache2, AndroidProjectKeys.JAVA_MODULE_MODEL)) == null) {
                return true;
            }
        }
        return (ndkFacet = NdkFacet.getInstance(module)) != null && (ndkModuleModelDataNode = ExternalSystemApiUtil.find(cache2, AndroidProjectKeys.NDK_MODEL)) == null;
    }

    public void clearCaches() {
        ExternalProjectInfo projectInfo = this.getExternalProjectInfo();
        if (projectInfo == null) {
            return;
        }
        DataNode cache2 = projectInfo.getExternalProjectStructure();
        if (cache2 == null) {
            return;
        }
        DataNodeCaches.clearCaches((DataNode<ProjectData>)cache2);
        ProjectDataManagerImpl.getInstance().updateExternalProjectData(this.myProject, projectInfo);
        this.myProject.save();
    }

    private static void clearCaches(@NotNull DataNode<ProjectData> cache2) {
        DataNodeCaches.clearCachesOfType(cache2, AndroidProjectKeys.GRADLE_MODULE_MODEL);
        DataNodeCaches.clearCachesOfType(cache2, AndroidProjectKeys.ANDROID_MODEL);
        DataNodeCaches.clearCachesOfType(cache2, AndroidProjectKeys.JAVA_MODULE_MODEL);
        DataNodeCaches.clearCachesOfType(cache2, AndroidProjectKeys.NDK_MODEL);
    }

    private static <T> void clearCachesOfType(@NotNull DataNode<ProjectData> cache2, @NotNull Key<T> type) {
        for (DataNode dataNode : ExternalSystemApiUtil.findAllRecursively(cache2, type)) {
            dataNode.clear(true);
        }
    }
}

