/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.android.AndroidModuleCleanupStep;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidModuleValidator;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleModelDataService
extends ModuleModelDataService<AndroidModuleModel> {
    @NotNull
    private final ModuleSetupContext.Factory myModuleSetupContextFactory;
    @NotNull
    private final AndroidModuleSetup myModuleSetup;
    @NotNull
    private final AndroidModuleValidator.Factory myModuleValidatorFactory;
    @NotNull
    private final AndroidModuleCleanupStep myCleanupStep;

    public AndroidModuleModelDataService() {
        this(new ModuleSetupContext.Factory(), new AndroidModuleSetup(), new AndroidModuleValidator.Factory(), new AndroidModuleCleanupStep());
    }

    @VisibleForTesting
    AndroidModuleModelDataService(@NotNull ModuleSetupContext.Factory moduleSetupContextFactory, @NotNull AndroidModuleSetup moduleSetup, @NotNull AndroidModuleValidator.Factory moduleValidatorFactory, @NotNull AndroidModuleCleanupStep cleanupStep) {
        this.myModuleSetupContextFactory = moduleSetupContextFactory;
        this.myModuleSetup = moduleSetup;
        this.myModuleValidatorFactory = moduleValidatorFactory;
        this.myCleanupStep = cleanupStep;
    }

    @NotNull
    public Key<AndroidModuleModel> getTargetDataKey() {
        return AndroidProjectKeys.ANDROID_MODEL;
    }

    @Override
    protected void importData(@NotNull Collection<DataNode<AndroidModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, AndroidModuleModel> modelsByModuleName) {
        AndroidModuleValidator moduleValidator = this.myModuleValidatorFactory.create(project);
        boolean syncSkipped = GradleSyncState.getInstance(project).isSyncSkipped();
        for (Module module : modelsProvider.getModules()) {
            AndroidModuleModel androidModel = modelsByModuleName.get(module.getName());
            this.setUpModule(module, moduleValidator, modelsProvider, androidModel, syncSkipped);
        }
        if (!modelsByModuleName.isEmpty()) {
            moduleValidator.fixAndReportFoundIssues();
        }
    }

    private void setUpModule(@NotNull Module module, @NotNull AndroidModuleValidator moduleValidator, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable AndroidModuleModel androidModel, boolean syncSkipped) {
        if (androidModel != null) {
            ModuleSetupContext context = this.myModuleSetupContextFactory.create(module, modelsProvider);
            this.myModuleSetup.setUpModule(context, androidModel, syncSkipped);
            moduleValidator.validate(module, androidModel);
        } else {
            this.onModelNotFound(module, modelsProvider);
        }
    }

    @Override
    protected void onModelNotFound(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        this.myCleanupStep.cleanUpModule(module, modelsProvider);
    }

    @NotNull
    public AndroidModuleSetup getModuleSetup() {
        return this.myModuleSetup;
    }
}

