/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.GradleModuleSetup;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GradleModuleModelDataService
extends ModuleModelDataService<GradleModuleModel> {
    @NotNull
    private final GradleModuleSetup myModuleSetup;

    public GradleModuleModelDataService() {
        this(new GradleModuleSetup());
    }

    GradleModuleModelDataService(@NotNull GradleModuleSetup moduleSetup) {
        this.myModuleSetup = moduleSetup;
    }

    @NotNull
    public Key<GradleModuleModel> getTargetDataKey() {
        return AndroidProjectKeys.GRADLE_MODULE_MODEL;
    }

    @Override
    protected void importData(@NotNull Collection<DataNode<GradleModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, GradleModuleModel> modelsByModuleName) {
        for (Module module : modelsProvider.getModules()) {
            GradleModuleModel gradleModuleModel = modelsByModuleName.get(module.getName());
            if (gradleModuleModel == null) {
                this.onModelNotFound(module, modelsProvider);
                continue;
            }
            this.myModuleSetup.setUpModule(module, modelsProvider, gradleModuleModel);
        }
    }

    @Override
    protected void onModelNotFound(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Facets.removeAllFacets(modelsProvider.getModifiableFacetModel(module), GradleFacet.getFacetTypeId());
    }
}

