/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.JavaModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.java.JavaModuleCleanupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaModuleModelDataService
extends ModuleModelDataService<JavaModuleModel> {
    @NotNull
    private final ModuleSetupContext.Factory myModuleSetupContextFactory;
    @NotNull
    private final JavaModuleSetup myModuleSetup;
    @NotNull
    private final JavaModuleCleanupStep myCleanupStep;

    public JavaModuleModelDataService() {
        this(new ModuleSetupContext.Factory(), new JavaModuleSetup(), new JavaModuleCleanupStep());
    }

    @VisibleForTesting
    JavaModuleModelDataService(@NotNull ModuleSetupContext.Factory moduleSetupContextFactory, @NotNull JavaModuleSetup moduleSetup, @NotNull JavaModuleCleanupStep cleanupStep) {
        this.myModuleSetupContextFactory = moduleSetupContextFactory;
        this.myModuleSetup = moduleSetup;
        this.myCleanupStep = cleanupStep;
    }

    @NotNull
    public Key<JavaModuleModel> getTargetDataKey() {
        return AndroidProjectKeys.JAVA_MODULE_MODEL;
    }

    @Override
    protected void importData(@NotNull Collection<DataNode<JavaModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, JavaModuleModel> modelsByModuleName) {
        boolean syncSkipped = GradleSyncState.getInstance(project).isSyncSkipped();
        for (Module module : modelsProvider.getModules()) {
            JavaModuleModel javaModuleModel = modelsByModuleName.get(module.getName());
            if (javaModuleModel != null) {
                ModuleSetupContext context = this.myModuleSetupContextFactory.create(module, modelsProvider);
                this.myModuleSetup.setUpModule(context, javaModuleModel, syncSkipped);
                continue;
            }
            this.onModelNotFound(module, modelsProvider);
        }
    }

    @Override
    protected void onModelNotFound(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        this.myCleanupStep.cleanUpModule(module, modelsProvider);
    }
}

