/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleModelDataService<T extends ModuleModel>
extends AbstractProjectDataService<T, Void> {
    public final void importData(@NotNull Collection<DataNode<T>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport.isEmpty()) {
            if (projectData != null && GradleUtil.GRADLE_SYSTEM_ID.equals((Object)projectData.getOwner())) {
                this.onModelsNotFound(modelsProvider);
            }
            return;
        }
        try {
            this.importData(toImport, project, modelsProvider);
        }
        catch (Throwable e) {
            this.getLog().info(String.format("Failed to set up modules in project '%1$s'", project.getName()), e);
            String msg = e.getMessage();
            GradleSyncState.getInstance(project).syncFailed(StringUtil.isNotEmpty((String)msg) ? msg : e.getClass().getCanonicalName());
        }
    }

    protected void onModelsNotFound(@NotNull IdeModifiableModelsProvider modelsProvider) {
        for (Module module : modelsProvider.getModules()) {
            this.onModelNotFound(module, modelsProvider);
        }
    }

    protected void onModelNotFound(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
    }

    private void importData(final @NotNull Collection<DataNode<T>> toImport, final @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) throws Throwable {
        RunResult result2 = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() {
                if (project.isDisposed()) {
                    return;
                }
                Map modelsByModuleName = ModuleModelDataService.this.indexByModuleName(toImport, modelsProvider);
                ModuleModelDataService.this.importData(toImport, project, modelsProvider, modelsByModuleName);
            }
        }.execute();
        Throwable error = result2.getThrowable();
        if (error != null) {
            throw error;
        }
    }

    protected abstract void importData(@NotNull Collection<DataNode<T>> var1, @NotNull Project var2, @NotNull IdeModifiableModelsProvider var3, @NotNull Map<String, T> var4);

    @NotNull
    private Map<String, T> indexByModuleName(@NotNull Collection<DataNode<T>> dataNodes, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (dataNodes.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, ModuleModel> index = new HashMap<String, ModuleModel>();
        for (DataNode<T> dataNode : dataNodes) {
            ModuleData moduleData;
            Module module;
            ModuleModel model2 = (ModuleModel)dataNode.getData();
            String moduleName = model2.getModuleName();
            if (dataNode.getParent() != null && (module = modelsProvider.findIdeModule(moduleData = (ModuleData)dataNode.getParent().getData())) != null && !module.getName().equals(moduleName)) {
                moduleName = module.getName();
            }
            index.put(moduleName, model2);
        }
        return index;
    }

    @NotNull
    protected Logger getLog() {
        return Logger.getInstance(((Object)((Object)this)).getClass());
    }
}

