/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.svs;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.Variant;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GraphItem;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.idea.svs.VariantGroup;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u000212B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020 2\b\u0010%\u001a\u0004\u0018\u00010 2\b\u0010&\u001a\u0004\u0018\u00010 H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010 J\u000e\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020 J\u001a\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020.2\b\u0010&\u001a\u0004\u0018\u00010 H\u0002J\u001a\u0010,\u001a\u00020(2\u0006\u0010/\u001a\u0002002\b\u0010&\u001a\u0004\u0018\u00010 H\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/android/tools/idea/gradle/project/sync/idea/svs/IdeaAndroidModule;", "", "ideaModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "androidProject", "Lcom/android/builder/model/AndroidProject;", "nativeAndroidProject", "Lcom/android/builder/model/NativeAndroidProject;", "(Lorg/gradle/tooling/model/idea/IdeaModule;Lcom/android/builder/model/AndroidProject;Lcom/android/builder/model/NativeAndroidProject;)V", "_moduleDependencies", "", "Lcom/android/tools/idea/gradle/project/sync/idea/svs/IdeaAndroidModule$ModuleDependency;", "getAndroidProject", "()Lcom/android/builder/model/AndroidProject;", "gradleProject", "Lorg/gradle/tooling/model/GradleProject;", "getGradleProject", "()Lorg/gradle/tooling/model/GradleProject;", "getIdeaModule", "()Lorg/gradle/tooling/model/idea/IdeaModule;", "moduleDependencies", "", "getModuleDependencies", "()Ljava/util/List;", "getNativeAndroidProject", "()Lcom/android/builder/model/NativeAndroidProject;", "variantGroup", "Lcom/android/tools/idea/gradle/project/sync/idea/svs/VariantGroup;", "getVariantGroup", "()Lcom/android/tools/idea/gradle/project/sync/idea/svs/VariantGroup;", "variantsByName", "", "", "Lcom/android/builder/model/Variant;", "addModuleDependency", "", "id", "variant", "abi", "addSelectedVariant", "", "selectedVariant", "containsVariant", "variantName", "populateDependencies", "dependencies", "Lcom/android/builder/model/Dependencies;", "dependencyGraphs", "Lcom/android/builder/model/level2/DependencyGraphs;", "Companion", "ModuleDependency", "intellij.android.core"})
public final class IdeaAndroidModule {
    private final List<ModuleDependency> _moduleDependencies;
    private final Map<String, Variant> variantsByName;
    @NotNull
    private final VariantGroup variantGroup;
    @NotNull
    private final IdeaModule ideaModule;
    @NotNull
    private final AndroidProject androidProject;
    @Nullable
    private final NativeAndroidProject nativeAndroidProject;
    @NotNull
    private static final Pattern MODULE_ARTIFACT_ADDRESS_PATTERN;
    public static final Companion Companion;

    @NotNull
    public final VariantGroup getVariantGroup() {
        return this.variantGroup;
    }

    @NotNull
    public final List<ModuleDependency> getModuleDependencies() {
        return this._moduleDependencies;
    }

    @NotNull
    public final GradleProject getGradleProject() {
        return this.ideaModule.getGradleProject();
    }

    public final boolean containsVariant(@NotNull String variantName) {
        return this.variantsByName.containsKey(variantName);
    }

    public final void addSelectedVariant(@NotNull Variant selectedVariant, @Nullable String abi) {
        Map<String, Variant> map2 = this.variantsByName;
        String string = selectedVariant.getName();
        Variant variant = selectedVariant;
        map2.put(string, variant);
        AndroidArtifact artifact = selectedVariant.getMainArtifact();
        Dependencies dependencies = artifact.getDependencies();
        if (dependencies.getLibraries().isEmpty()) {
            this.populateDependencies(artifact.getDependencyGraphs(), abi);
        } else {
            this.populateDependencies(dependencies, abi);
        }
    }

    private final void populateDependencies(Dependencies dependencies, String abi) {
        Iterable $receiver$iv = dependencies.getLibraries();
        for (Object element$iv : $receiver$iv) {
            String project;
            AndroidLibrary library = (AndroidLibrary)element$iv;
            boolean bl = false;
            if (library.getProject() == null) {
                return;
            }
            Object object = library;
            if (object == null || (object = object.getBuildId()) == null) {
                object = "";
            }
            this.addModuleDependency(Modules.createUniqueModuleId((String)object, project), library.getProjectVariant(), abi);
        }
    }

    private final void populateDependencies(DependencyGraphs dependencyGraphs, String abi) {
        Iterable $receiver$iv = dependencyGraphs.getCompileDependencies();
        for (Object element$iv : $receiver$iv) {
            GraphItem item = (GraphItem)element$iv;
            boolean bl = false;
            Matcher matcher = MODULE_ARTIFACT_ADDRESS_PATTERN.matcher(item.getArtifactAddress());
            if (!matcher.matches()) continue;
            String buildId2 = matcher.group(1);
            String project = matcher.group(2);
            if (buildId2 == null || project == null) continue;
            this.addModuleDependency(Modules.createUniqueModuleId(buildId2, project), matcher.group(4), abi);
        }
    }

    private final boolean addModuleDependency(String id, String variant, String abi) {
        return this._moduleDependencies.add(new ModuleDependency(id, variant, abi));
    }

    @NotNull
    public final IdeaModule getIdeaModule() {
        return this.ideaModule;
    }

    @NotNull
    public final AndroidProject getAndroidProject() {
        return this.androidProject;
    }

    @Nullable
    public final NativeAndroidProject getNativeAndroidProject() {
        return this.nativeAndroidProject;
    }

    public IdeaAndroidModule(@NotNull IdeaModule ideaModule, @NotNull AndroidProject androidProject, @Nullable NativeAndroidProject nativeAndroidProject) {
        this.ideaModule = ideaModule;
        this.androidProject = androidProject;
        this.nativeAndroidProject = nativeAndroidProject;
        IdeaAndroidModule ideaAndroidModule = this;
        Object object = new ArrayList();
        ideaAndroidModule._moduleDependencies = object;
        ideaAndroidModule = this;
        ideaAndroidModule.variantsByName = object = (Map)new LinkedHashMap();
        this.variantGroup = new VariantGroup(null, null, 3, null);
    }

    static {
        Companion = new Companion(null);
        MODULE_ARTIFACT_ADDRESS_PATTERN = Pattern.compile("([^@]*)@@(.[^:]*)(::(.*))?");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/gradle/project/sync/idea/svs/IdeaAndroidModule$ModuleDependency;", "", "id", "", "variant", "abi", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAbi", "()Ljava/lang/String;", "getId", "getVariant", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.core"})
    public static final class ModuleDependency {
        @NotNull
        private final String id;
        @Nullable
        private final String variant;
        @Nullable
        private final String abi;

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getVariant() {
            return this.variant;
        }

        @Nullable
        public final String getAbi() {
            return this.abi;
        }

        public ModuleDependency(@NotNull String id, @Nullable String variant, @Nullable String abi) {
            this.id = id;
            this.variant = variant;
            this.abi = abi;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @Nullable
        public final String component2() {
            return this.variant;
        }

        @Nullable
        public final String component3() {
            return this.abi;
        }

        @NotNull
        public final ModuleDependency copy(@NotNull String id, @Nullable String variant, @Nullable String abi) {
            return new ModuleDependency(id, variant, abi);
        }

        @NotNull
        public static /* synthetic */ ModuleDependency copy$default(ModuleDependency moduleDependency, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = moduleDependency.id;
            }
            if ((n & 2) != 0) {
                string2 = moduleDependency.variant;
            }
            if ((n & 4) != 0) {
                string3 = moduleDependency.abi;
            }
            return moduleDependency.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ModuleDependency(id=" + this.id + ", variant=" + this.variant + ", abi=" + this.abi + ")";
        }

        public int hashCode() {
            String string = this.id;
            String string2 = this.variant;
            String string3 = this.abi;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ModuleDependency)) break block3;
                    ModuleDependency moduleDependency = (ModuleDependency)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)moduleDependency.id) || !Intrinsics.areEqual((Object)this.variant, (Object)moduleDependency.variant) || !Intrinsics.areEqual((Object)this.abi, (Object)moduleDependency.abi)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/gradle/project/sync/idea/svs/IdeaAndroidModule$Companion;", "", "()V", "MODULE_ARTIFACT_ADDRESS_PATTERN", "Ljava/util/regex/Pattern;", "getMODULE_ARTIFACT_ADDRESS_PATTERN", "()Ljava/util/regex/Pattern;", "intellij.android.core"})
    public static final class Companion {
        @NotNull
        public final Pattern getMODULE_ARTIFACT_ADDRESS_PATTERN() {
            return MODULE_ARTIFACT_ADDRESS_PATTERN;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

