/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.util.PositionInFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseSyncIssuesReporter {
    BaseSyncIssuesReporter() {
    }

    @NotNull
    GradleSyncMessages getSyncMessages(@NotNull Module module) {
        return GradleSyncMessages.getInstance(module.getProject());
    }

    abstract int getSupportedIssueType();

    abstract void report(@NotNull SyncIssue var1, @NotNull Module var2, @Nullable VirtualFile var3, @NotNull SyncIssueUsageReporter var4);

    void reportAll(@NotNull List<SyncIssue> syncIssues, @NotNull Map<SyncIssue, Module> moduleMap, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull SyncIssueUsageReporter usageReporter) {
        for (SyncIssue issue2 : syncIssues) {
            this.report(issue2, moduleMap.get(issue2), buildFileMap.get(moduleMap.get(issue2)), usageReporter);
        }
    }

    static boolean affectedModulesContainKts(List<Module> modules, Map<Module, VirtualFile> buildFileMap) {
        return modules.stream().map(module -> (VirtualFile)buildFileMap.get(module)).filter(Objects::nonNull).anyMatch(GradleUtil::isKtsFile);
    }

    @NotNull
    static MessageType getMessageType(@NotNull SyncIssue syncIssue) {
        return syncIssue.getSeverity() == 2 ? MessageType.ERROR : MessageType.WARNING;
    }

    @NotNull
    static SyncMessage generateSyncMessage(@NotNull SyncIssue syncIssue, @NotNull Module module, @Nullable VirtualFile buildFile) {
        SyncMessage message2;
        if (buildFile != null) {
            PositionInFile position = new PositionInFile(buildFile);
            message2 = new SyncMessage(module.getProject(), "Gradle Sync Issues", MessageType.findFromSyncIssue(syncIssue), position, syncIssue.getMessage());
        } else {
            message2 = new SyncMessage("Gradle Sync Issues", MessageType.findFromSyncIssue(syncIssue), syncIssue.getMessage());
        }
        return message2;
    }
}

