/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.project.sync.errors.SdkBuildToolsTooLowErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SimpleDeduplicatingSyncIssueReporter;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class BuildToolsTooLowReporter
extends SimpleDeduplicatingSyncIssueReporter {
    @NotNull
    private final SdkBuildToolsTooLowErrorHandler myErrorHandler;

    BuildToolsTooLowReporter() {
        this(SdkBuildToolsTooLowErrorHandler.getInstance());
    }

    @VisibleForTesting
    BuildToolsTooLowReporter(@NotNull SdkBuildToolsTooLowErrorHandler errorHandler) {
        this.myErrorHandler = errorHandler;
    }

    @Override
    int getSupportedIssueType() {
        return 13;
    }

    @Override
    @NotNull
    protected OpenFileHyperlink createModuleLink(@NotNull Project project, @NotNull Module module, @NotNull ProjectBuildModel projectBuildModel, @NotNull List<SyncIssue> syncIssues, @NotNull VirtualFile buildFile) {
        GradleBuildModel buildModel = projectBuildModel.getModuleBuildModel(buildFile);
        PsiElement element = buildModel.android().buildToolsVersion().getPsiElement();
        int lineNumber = BuildToolsTooLowReporter.getLineNumberForElement(project, element);
        return new OpenFileHyperlink(buildFile.getPath(), module.getName(), lineNumber, -1);
    }

    @Override
    @NotNull
    protected Object getDeduplicationKey(@NotNull SyncIssue issue2) {
        return issue2;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<SyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        assert (!syncIssues.isEmpty() && !affectedModules.isEmpty());
        String minimumVersion = syncIssues.get(0).getData();
        if (minimumVersion == null) {
            return ImmutableList.of();
        }
        return this.myErrorHandler.getQuickFixHyperlinks(minimumVersion, affectedModules, buildFileMap);
    }
}

