/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SimpleDeduplicatingSyncIssueReporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeprecatedConfigurationReporter
extends SimpleDeduplicatingSyncIssueReporter {
    @Override
    int getSupportedIssueType() {
        return 29;
    }

    @Override
    @NotNull
    protected OpenFileHyperlink createModuleLink(@NotNull Project project, @NotNull Module module, @NotNull ProjectBuildModel projectBuildModel, @NotNull List<SyncIssue> syncIssues, @NotNull VirtualFile buildFile) {
        assert (!syncIssues.isEmpty());
        String config = DeprecatedConfigurationReporter.extractConfigurationName(syncIssues.get(0));
        GradleBuildModel buildModel = projectBuildModel.getModuleBuildModel(buildFile);
        DependencyModel dependencyModel = buildModel.dependencies().all().stream().filter(model2 -> model2.configurationName().equals(config)).findFirst().orElse(null);
        if (dependencyModel == null) {
            return super.createModuleLink(project, module, projectBuildModel, syncIssues, buildFile);
        }
        int lineNumber = DeprecatedConfigurationReporter.getLineNumberForElement(project, dependencyModel.getPsiElement());
        return new OpenFileHyperlink(buildFile.getPath(), module.getName(), lineNumber, -1);
    }

    @Override
    @NotNull
    protected String getDeduplicationKey(@NotNull SyncIssue issue2) {
        String config = DeprecatedConfigurationReporter.extractConfigurationName(issue2);
        return config != null ? config : issue2.toString();
    }

    @Nullable
    private static String extractConfigurationName(@NotNull SyncIssue issue2) {
        String data = issue2.getData();
        if (data == null) {
            return null;
        }
        String[] parts = data.split("::");
        if (parts.length < 1) {
            return null;
        }
        return parts[0];
    }
}

