/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.ProductFlavorModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.RemoveSdkFromManifestHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SimpleDeduplicatingSyncIssueReporter;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.UsesSdk;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;

public abstract class SdkInManifestIssuesReporter
extends SimpleDeduplicatingSyncIssueReporter {
    @Override
    protected abstract int getSupportedIssueType();

    @NotNull
    protected abstract SdkProperty getProperty();

    @Override
    @NotNull
    protected OpenFileHyperlink createModuleLink(@NotNull Project project, @NotNull Module module, @NotNull ProjectBuildModel projectBuildModel, @NotNull List<SyncIssue> syncIssues, @NotNull VirtualFile buildFile) {
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet != null) {
            VirtualFile manifestFile;
            Manifest manifest = androidFacet.getManifest();
            PsiElement element = null;
            if (manifest != null) {
                element = (PsiElement)ApplicationManager.getApplication().runReadAction(() -> {
                    List<UsesSdk> usesSdks = manifest.getUsesSdks();
                    if (!usesSdks.isEmpty()) {
                        return usesSdks.get(0).getXmlElement();
                    }
                    return null;
                });
            }
            if ((manifestFile = AndroidRootUtil.getPrimaryManifestFile(androidFacet)) != null) {
                int lineNumber = element != null ? SdkInManifestIssuesReporter.getLineNumberForElement(project, element) : -1;
                return new OpenFileHyperlink(manifestFile.getPath(), module.getName(), lineNumber, -1);
            }
        }
        return super.createModuleLink(project, module, projectBuildModel, syncIssues, buildFile);
    }

    @Override
    @NotNull
    protected Object getDeduplicationKey(@NotNull SyncIssue issue2) {
        return issue2;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<SyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        if (affectedModules.isEmpty()) {
            return ImmutableList.of();
        }
        if (SdkInManifestIssuesReporter.affectedModulesContainKts(affectedModules, buildFileMap)) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)new RemoveSdkFromManifestHyperlink(affectedModules, this.getProperty()));
    }

    public static enum SdkProperty {
        MIN("minSdkVersion", 14, UsesSdk::getMinSdkVersion, ProductFlavorModel::minSdkVersion),
        TARGET("targetSdkVersion", 28, UsesSdk::getTargetSdkVersion, ProductFlavorModel::targetSdkVersion),
        MAX("maxSdkVersion", 29, UsesSdk::getMaxSdkVersion, ProductFlavorModel::maxSdkVersion);

        @NotNull
        private final String myName;
        private final int myDefaultValue;
        @NotNull
        private final Function<UsesSdk, AndroidAttributeValue<String>> myManifestFunction;
        @NotNull
        private final Function<ProductFlavorModel, ResolvedPropertyModel> myBuildFileFunction;

        private SdkProperty(@NotNull String propertyName, @NotNull int defaultValue, Function<UsesSdk, AndroidAttributeValue<String>> manifestFunction, Function<ProductFlavorModel, ResolvedPropertyModel> buildFileFunction) {
            this.myName = propertyName;
            this.myDefaultValue = defaultValue;
            this.myManifestFunction = manifestFunction;
            this.myBuildFileFunction = buildFileFunction;
        }

        @NotNull
        public String getPropertyName() {
            return this.myName;
        }

        public int getDefaultValue() {
            return this.myDefaultValue;
        }

        @NotNull
        public Function<UsesSdk, AndroidAttributeValue<String>> getManifestFunction() {
            return this.myManifestFunction;
        }

        @NotNull
        public Function<ProductFlavorModel, ResolvedPropertyModel> getBuildFileFunction() {
            return this.myBuildFileFunction;
        }
    }
}

