/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporterUtils;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.ui.QuickFixNotificationListener;
import com.android.tools.idea.util.PositionInFile;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleDeduplicatingSyncIssueReporter
extends BaseSyncIssuesReporter {
    @Override
    final void report(@NotNull SyncIssue syncIssue, @NotNull Module module, @Nullable VirtualFile buildFile, @NotNull SyncIssueUsageReporter usageReporter) {
        this.reportAll((List<SyncIssue>)ImmutableList.of((Object)syncIssue), (Map<SyncIssue, Module>)ImmutableMap.of((Object)syncIssue, (Object)module), (Map<Module, VirtualFile>)(buildFile == null ? ImmutableMap.of() : ImmutableMap.of((Object)module, (Object)buildFile)), usageReporter);
    }

    @Override
    final void reportAll(@NotNull List<SyncIssue> syncIssues, @NotNull Map<SyncIssue, Module> moduleMap, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull SyncIssueUsageReporter usageReporter) {
        LinkedHashMap<Object, List> groupedIssues = new LinkedHashMap<Object, List>();
        for (SyncIssue issue2 : syncIssues) {
            groupedIssues.computeIfAbsent(this.getDeduplicationKey(issue2), config -> new ArrayList()).add(issue2);
        }
        for (List entry : groupedIssues.values()) {
            SyncIssue issue3;
            Module module;
            if (entry.isEmpty() || (module = moduleMap.get(issue3 = (SyncIssue)entry.get(0))) == null) continue;
            List<Module> affectedModules = entry.stream().map(moduleMap::get).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(Module::getName)).collect(Collectors.toList());
            boolean isError = entry.stream().anyMatch(i2 -> i2.getSeverity() == 2);
            this.createNotificationDataAndReport(module.getProject(), entry, affectedModules, buildFileMap, isError, usageReporter);
        }
    }

    private void createNotificationDataAndReport(@NotNull Project project, @NotNull List<SyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, boolean isError, @NotNull SyncIssueUsageReporter usageReporter) {
        MessageType type;
        GradleSyncMessages messages = GradleSyncMessages.getInstance(project);
        MessageType messageType = type = isError ? MessageType.ERROR : MessageType.INFO;
        assert (!syncIssues.isEmpty());
        NotificationData notification = this.setupNotificationData(project, syncIssues, affectedModules, buildFileMap, type);
        StringBuilder builder = new StringBuilder();
        List<NotificationHyperlink> customLinks = this.getCustomLinks(project, syncIssues, affectedModules, buildFileMap);
        messages.updateNotification(notification, notification.getMessage(), customLinks);
        SyncIssueUsageReporterUtils.collect(usageReporter, this.getSupportedIssueType(), customLinks);
        String message2 = notification.getMessage().trim();
        ProjectBuildModel projectBuildModel = ProjectBuildModel.getOrLog(project);
        if (projectBuildModel != null && this.shouldIncludeModuleLinks() && !affectedModules.isEmpty()) {
            builder.append("\nAffected Modules: ");
            Iterator<Module> it = affectedModules.iterator();
            while (it.hasNext()) {
                Module m = it.next();
                if (m == null) continue;
                this.doCreateModuleLink(project, notification, builder, m, projectBuildModel, syncIssues, buildFileMap.get(m));
                if (!it.hasNext()) continue;
                builder.append(", ");
            }
        }
        message2 = message2 + builder.toString();
        notification.setMessage(message2);
        messages.report(notification);
    }

    private void doCreateModuleLink(@NotNull Project project, @NotNull NotificationData notification, @NotNull StringBuilder builder, @NotNull Module module, @NotNull ProjectBuildModel projectBuildModel, @NotNull List<SyncIssue> syncIssues, @Nullable VirtualFile buildFile) {
        if (buildFile == null) {
            builder.append(module.getName());
        } else {
            OpenFileHyperlink link = this.createModuleLink(project, module, projectBuildModel, syncIssues, buildFile);
            builder.append(link.toHtml());
            notification.setListener(link.getUrl(), (NotificationListener)new QuickFixNotificationListener(project, link));
        }
    }

    @NotNull
    protected OpenFileHyperlink createModuleLink(@NotNull Project project, @NotNull Module module, @NotNull ProjectBuildModel projectBuildModel, @NotNull List<SyncIssue> syncIssues, @NotNull VirtualFile buildFile) {
        return new OpenFileHyperlink(buildFile.getPath(), module.getName(), -1, -1);
    }

    @NotNull
    protected abstract Object getDeduplicationKey(@NotNull SyncIssue var1);

    protected boolean shouldIncludeModuleLinks() {
        return true;
    }

    @NotNull
    protected List<NotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<SyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        return ImmutableList.of();
    }

    @NotNull
    protected NotificationData setupNotificationData(@NotNull Project project, @NotNull List<SyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull MessageType type) {
        VirtualFile file;
        assert (!syncIssues.isEmpty());
        GradleSyncMessages messages = GradleSyncMessages.getInstance(project);
        PositionInFile position = null;
        if (affectedModules.size() == 1 && (file = buildFileMap.get(affectedModules.get(0))) != null) {
            position = new PositionInFile(file);
        }
        NotificationData data = messages.createNotification("Gradle Sync Issues", syncIssues.get(0).getMessage(), type.convertToCategory(), position);
        if (position != null) {
            data.setNavigatable((Navigatable)new OpenFileDescriptor(project, position.file, position.line, position.column));
        }
        return data;
    }

    public static int getLineNumberForElement(@NotNull Project project, @Nullable PsiElement element) {
        return (Integer)ApplicationManager.getApplication().runReadAction(() -> {
            Document document;
            if (element != null && (document = PsiDocumentManager.getInstance((Project)project).getDocument(element.getContainingFile())) != null) {
                return document.getLineNumber(element.getTextOffset());
            }
            return -1;
        });
    }
}

