/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.BuildToolsTooLowReporter;
import com.android.tools.idea.gradle.project.sync.issues.DeprecatedConfigurationReporter;
import com.android.tools.idea.gradle.project.sync.issues.ExternalNdkBuildIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.MinSdkInManifestIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.MissingSdkIssueReporter;
import com.android.tools.idea.gradle.project.sync.issues.MissingSdkPackageSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.OutOfDateThirdPartyPluginIssueReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueRegister;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.android.tools.idea.gradle.project.sync.issues.TargetSdkInManifestIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnhandledIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnresolvedDependenciesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnsupportedGradleReporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SyncIssuesReporter {
    @NotNull
    private final Map<Integer, BaseSyncIssuesReporter> myStrategies = new HashMap<Integer, BaseSyncIssuesReporter>(6);
    @NotNull
    private final BaseSyncIssuesReporter myDefaultMessageFactory;

    @NotNull
    public static SyncIssuesReporter getInstance() {
        return (SyncIssuesReporter)ServiceManager.getService(SyncIssuesReporter.class);
    }

    public SyncIssuesReporter(@NotNull UnresolvedDependenciesReporter unresolvedDependenciesReporter) {
        this(unresolvedDependenciesReporter, new ExternalNdkBuildIssuesReporter(), new UnsupportedGradleReporter(), new BuildToolsTooLowReporter(), new MissingSdkPackageSyncIssuesReporter(), new MinSdkInManifestIssuesReporter(), new TargetSdkInManifestIssuesReporter(), new DeprecatedConfigurationReporter(), new MissingSdkIssueReporter(), new OutOfDateThirdPartyPluginIssueReporter());
    }

    @VisibleForTesting
    SyncIssuesReporter(BaseSyncIssuesReporter ... strategies) {
        for (BaseSyncIssuesReporter strategy : strategies) {
            int issueType = strategy.getSupportedIssueType();
            this.myStrategies.put(issueType, strategy);
        }
        this.myDefaultMessageFactory = new UnhandledIssuesReporter();
    }

    public void report(@NotNull Project project) {
        SyncIssueRegister.getInstance(project).seal();
        this.report(SyncIssueRegister.getInstance(project).get());
    }

    @VisibleForTesting
    public void report(@NotNull Map<Module, List<SyncIssue>> issuesByModules) {
        if (issuesByModules.isEmpty()) {
            return;
        }
        LinkedHashMap syncIssues = new LinkedHashMap();
        IdentityHashMap<SyncIssue, Module> moduleMap = new IdentityHashMap<SyncIssue, Module>();
        LinkedHashMap<Module, VirtualFile> buildFileMap = new LinkedHashMap<Module, VirtualFile>();
        Project project = null;
        boolean[] hasSyncErrors = new boolean[1];
        for (Module module : issuesByModules.keySet()) {
            project = module.getProject();
            buildFileMap.put(module, GradleUtil.getGradleBuildFile(module));
            issuesByModules.get(module).forEach(issue2 -> {
                if (issue2 != null) {
                    syncIssues.computeIfAbsent(issue2.getType(), type -> new ArrayList()).add(issue2);
                    moduleMap.put((SyncIssue)issue2, module);
                    if (issue2.getSeverity() == 2) {
                        hasSyncErrors[0] = true;
                    }
                }
            });
        }
        Map sortedSyncIssues = syncIssues.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue(Comparator.comparing(issues -> ((SyncIssue)issues.get(0)).getSeverity())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldVal, newVal) -> oldVal, LinkedHashMap::new));
        SyncIssueUsageReporter syncIssueUsageReporter = SyncIssueUsageReporter.Companion.getInstance(project);
        for (Map.Entry entry : sortedSyncIssues.entrySet()) {
            BaseSyncIssuesReporter strategy = this.myStrategies.get(entry.getKey());
            if (strategy == null) {
                strategy = this.myDefaultMessageFactory;
            }
            strategy.reportAll((List)entry.getValue(), moduleMap, buildFileMap, syncIssueUsageReporter);
        }
        if (hasSyncErrors[0]) {
            GradleSyncState.getInstance(project).getSummary().setSyncErrorsFound(true);
        }
    }

    @VisibleForTesting
    @NotNull
    Map<Integer, BaseSyncIssuesReporter> getStrategies() {
        return this.myStrategies;
    }

    @VisibleForTesting
    @NotNull
    BaseSyncIssuesReporter getDefaultMessageFactory() {
        return this.myDefaultMessageFactory;
    }
}

