/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.AddGoogleMavenRepositoryHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.DisableOfflineModeHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ShowDependencyInProjectStructureHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ShowSyncIssuesDetailsHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SimpleDeduplicatingSyncIssueReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnresolvedDependenciesReporter
extends SimpleDeduplicatingSyncIssueReporter {
    private static final String UNRESOLVED_DEPENDENCIES_GROUP = "Unresolved dependencies";

    @NotNull
    public static UnresolvedDependenciesReporter getInstance() {
        return (UnresolvedDependenciesReporter)ServiceManager.getService(UnresolvedDependenciesReporter.class);
    }

    @Override
    int getSupportedIssueType() {
        return 2;
    }

    @Override
    @NotNull
    protected OpenFileHyperlink createModuleLink(@NotNull Project project, @NotNull Module module, @NotNull ProjectBuildModel projectBuildModel, @NotNull List<SyncIssue> syncIssues, @NotNull VirtualFile buildFile) {
        assert (!syncIssues.isEmpty());
        String dependency = syncIssues.get(0).getData();
        GradleBuildModel buildModel = projectBuildModel.getModuleBuildModel(buildFile);
        ArtifactDependencyModel dependencyModel = buildModel.dependencies().artifacts().stream().filter(artifact -> artifact.compactNotation().equals(dependency)).findFirst().orElse(null);
        PsiElement element = dependencyModel == null ? null : dependencyModel.getPsiElement();
        int lineNumber = UnresolvedDependenciesReporter.getLineNumberForElement(project, element);
        return new OpenFileHyperlink(buildFile.getPath(), module.getName(), lineNumber, -1);
    }

    @Override
    @NotNull
    protected Object getDeduplicationKey(@NotNull SyncIssue issue2) {
        return issue2;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<SyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        assert (!syncIssues.isEmpty() && !affectedModules.isEmpty());
        SyncIssue issue2 = syncIssues.get(0);
        String dependency = issue2.getData();
        ArrayList quickFixes = Lists.newArrayList();
        if (dependency == null) {
            ArrayList<String> extraInfo = new ArrayList<String>();
            try {
                List multiLineMessage = issue2.getMultiLineMessage();
                if (multiLineMessage != null) {
                    extraInfo.addAll(multiLineMessage);
                }
            }
            catch (UnsupportedOperationException multiLineMessage) {
                // empty catch block
            }
            if (!extraInfo.isEmpty()) {
                quickFixes.add(new ShowSyncIssuesDetailsHyperlink(issue2.getMessage(), extraInfo));
            }
            if (GradleProjects.isOfflineBuildModeEnabled(project)) {
                quickFixes.add(0, new DisableOfflineModeHyperlink());
            }
            return quickFixes;
        }
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)dependency);
        List<VirtualFile> buildFiles = affectedModules.stream().map(m -> (VirtualFile)buildFileMap.get(m)).collect(Collectors.toList());
        Module module = affectedModules.get(0);
        if (dependency.startsWith("com.android.support") || dependency.startsWith("androidx.") || dependency.startsWith("com.google.android")) {
            UnresolvedDependenciesReporter.addGoogleMavenRepositoryHyperlink(project, buildFiles, quickFixes);
        } else if (GradleProjects.isOfflineBuildModeEnabled(project)) {
            quickFixes.add(new DisableOfflineModeHyperlink());
        }
        if (IdeInfo.getInstance().isAndroidStudio() && buildFileMap.values().stream().noneMatch(GradleUtil::isKtsFile) && coordinate != null) {
            quickFixes.add(new ShowDependencyInProjectStructureHyperlink(module, coordinate));
        }
        return quickFixes;
    }

    @Override
    @NotNull
    protected NotificationData setupNotificationData(@NotNull Project project, @NotNull List<SyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull MessageType type) {
        NotificationData notificationData = super.setupNotificationData(project, syncIssues, affectedModules, buildFileMap, type);
        notificationData.setTitle(UNRESOLVED_DEPENDENCIES_GROUP);
        String dependency = syncIssues.get(0).getData();
        if (dependency == null) {
            return notificationData;
        }
        String message2 = "Failed to resolve: " + dependency;
        notificationData.setMessage(message2);
        return notificationData;
    }

    public void report(@NotNull Collection<String> unresolvedDependencies, @NotNull Module module) {
        if (unresolvedDependencies.isEmpty()) {
            return;
        }
        VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
        List<SyncIssue> syncIssues = unresolvedDependencies.stream().map(s -> new SyncIssue((String)s){
            final /* synthetic */ String val$s;
            {
                this.val$s = string;
            }

            public int getSeverity() {
                return 2;
            }

            public int getType() {
                return 2;
            }

            @Nullable
            public String getData() {
                return this.val$s;
            }

            public String getMessage() {
                return this.val$s;
            }

            @Nullable
            public List<String> getMultiLineMessage() {
                return null;
            }
        }).collect(Collectors.toList());
        SyncIssueUsageReporter syncIssueUsageReporter = SyncIssueUsageReporter.Companion.getInstance(module.getProject());
        this.reportAll(syncIssues, syncIssues.stream().collect(Collectors.toMap(Function.identity(), k -> module)), (Map<Module, VirtualFile>)(buildFile == null ? ImmutableMap.of() : ImmutableMap.of((Object)module, (Object)buildFile)), syncIssueUsageReporter);
    }

    @NotNull
    private static Collection<RemotePackage> getRemotePackages(@NotNull ProgressIndicator indicator) {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        RepositoryPackages packages = sdkHandler.getSdkManager(indicator).getPackages();
        return packages.getRemotePackages().values();
    }

    private static void addGoogleMavenRepositoryHyperlink(@NotNull Project project, @NotNull List<VirtualFile> buildFiles, @NotNull List<NotificationHyperlink> fixes) {
        if (!project.isInitialized()) {
            fixes.add(new AddGoogleMavenRepositoryHyperlink(project));
            return;
        }
        ProjectBuildModel projectBuildModel = ProjectBuildModel.getOrLog(project);
        if (projectBuildModel == null) {
            return;
        }
        ArrayList<VirtualFile> filesToFix = new ArrayList<VirtualFile>();
        for (VirtualFile file : buildFiles) {
            GradleBuildModel moduleModel;
            if (file == null || !file.isValid() || (moduleModel = projectBuildModel.getModuleBuildModel(file)).repositories().hasGoogleMavenRepository()) continue;
            filesToFix.add(file);
        }
        if (filesToFix.isEmpty()) {
            return;
        }
        GradleBuildModel buildModel = projectBuildModel.getProjectBuildModel();
        if (buildModel != null && !buildModel.repositories().hasGoogleMavenRepository()) {
            fixes.add(new AddGoogleMavenRepositoryHyperlink((List<VirtualFile>)ImmutableList.of((Object)buildModel.getVirtualFile())));
            return;
        }
        fixes.add(new AddGoogleMavenRepositoryHyperlink(filesToFix));
    }
}

