/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues.processor;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.issues.SdkInManifestIssuesReporter;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.UsesSdk;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class RemoveSdkFromManifestProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final Collection<Module> myModules;
    @NotNull
    private final SdkInManifestIssuesReporter.SdkProperty myProperty;

    public RemoveSdkFromManifestProcessor(@NotNull Project project, @NotNull Collection<Module> modules, @NotNull SdkInManifestIssuesReporter.SdkProperty property2) {
        super(project);
        this.myModules = modules;
        this.myProperty = property2;
    }

    @NotNull
    public UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new UsageViewDescriptorAdapter(){

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return String.format("Propert%s to move/remove %s", usagesCount > 1 ? "ies" : "y", UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount));
            }

            @NotNull
            public PsiElement[] getElements() {
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return String.format("Remove %s from manifest%s", RemoveSdkFromManifestProcessor.this.myProperty.getPropertyName(), RemoveSdkFromManifestProcessor.this.myModules.size() > 1 ? "s" : "");
            }
        };
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList usages = new ArrayList();
        this.runOverSdkManifestElements((module, usesSdk) -> {
            XmlElement element = this.myProperty.getManifestFunction().apply((UsesSdk)usesSdk).getXmlElement();
            if (element != null) {
                usages.add(new UsageInfo((PsiElement)element));
            }
        });
        return usages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        Ref xmlChanged = new Ref((Object)false);
        Ref buildFileChanged = new Ref((Object)false);
        this.runOverSdkManifestElements((module, usesSdk) -> {
            ResolvedPropertyModel propertyInBuildModel;
            GradleBuildModel buildModel;
            int defaultVersion = this.myProperty.getDefaultValue();
            AndroidAttributeValue<String> androidAttributeValue = this.myProperty.getManifestFunction().apply((UsesSdk)usesSdk);
            try {
                defaultVersion = Integer.parseInt(Strings.nullToEmpty((String)androidAttributeValue.getStringValue()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            XmlElement element = androidAttributeValue.getXmlElement();
            if (element != null) {
                xmlChanged.set((Object)true);
                element.delete();
                if (usesSdk.getXmlTag().getAttributes().length == 0) {
                    usesSdk.getXmlTag().delete();
                }
            }
            if ((buildModel = projectBuildModel.getModuleBuildModel((Module)module)) != null && (propertyInBuildModel = this.getSdkPropertyInBuildModel(buildModel)).getValueType() == GradlePropertyModel.ValueType.NONE) {
                buildFileChanged.set((Object)true);
                propertyInBuildModel.setValue(defaultVersion);
            }
        });
        if (((Boolean)buildFileChanged.get()).booleanValue()) {
            projectBuildModel.applyChanges();
        }
        if (((Boolean)xmlChanged.get()).booleanValue()) {
            FileDocumentManager.getInstance().saveAllDocuments();
        }
        if (((Boolean)xmlChanged.get()).booleanValue() || ((Boolean)buildFileChanged.get()).booleanValue()) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_QF_SDK_REMOVED_FROM_MANIFEST);
        }
    }

    @NotNull
    protected String getCommandName() {
        return String.format("Remove %s from manifest%s", this.myProperty.getPropertyName(), this.myModules.size() > 1 ? "s" : "");
    }

    @NotNull
    private ResolvedPropertyModel getSdkPropertyInBuildModel(@NotNull GradleBuildModel buildModel) {
        return this.myProperty.getBuildFileFunction().apply(buildModel.android().defaultConfig());
    }

    private void runOverSdkManifestElements(@NotNull BiConsumer<Module, UsesSdk> func) {
        for (Module module : this.myModules) {
            Manifest manifest;
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet == null || (manifest = androidFacet.getManifest()) == null) continue;
            for (UsesSdk usesSdk : manifest.getUsesSdks()) {
                func.accept(module, usesSdk);
            }
        }
    }
}

