/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.common.VariantSelector;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSync;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidModelFactory {
    @NotNull
    private final VariantSelector myVariantSelector;
    @NotNull
    private final IdeDependenciesFactory myDependenciesFactory;

    AndroidModelFactory(@NotNull VariantSelector variantSelector, @NotNull IdeDependenciesFactory dependenciesFactory) {
        this.myVariantSelector = variantSelector;
        this.myDependenciesFactory = dependenciesFactory;
    }

    @Nullable
    AndroidModuleModel createAndroidModel(@NotNull Module module, @NotNull AndroidProject androidProject, @NotNull GradleModuleModels moduleModels) {
        AndroidModuleModel androidModel;
        List<Variant> variants;
        if (NewGradleSync.isSingleVariantSync(module.getProject()) && androidProject.getVariants().isEmpty() && (variants = moduleModels.findModels(Variant.class)) != null && (androidModel = this.createAndroidModel(module, androidProject, variants, true)) != null) {
            return androidModel;
        }
        Variant variantToSelect = this.myVariantSelector.findVariantToSelect(androidProject);
        if (variantToSelect != null && (androidModel = this.createAndroidModel(module, androidProject, Collections.singletonList(variantToSelect), false)) != null) {
            return androidModel;
        }
        return null;
    }

    @Nullable
    private AndroidModuleModel createAndroidModel(@NotNull Module module, @NotNull AndroidProject androidProject, @NotNull List<Variant> variants, boolean addVariantToAndroidProject) {
        File moduleRootFolderPath = GradleProjects.findModuleRootFolderPath(module);
        if (moduleRootFolderPath != null) {
            String selectedVariant = variants.get(variants.size() - 1).getName();
            List<Variant> variantsToAdd = addVariantToAndroidProject ? variants : null;
            return new AndroidModuleModel(module.getName(), moduleRootFolderPath, androidProject, selectedVariant, this.myDependenciesFactory, variantsToAdd);
        }
        return null;
    }
}

