/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.Variant;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GraphItem;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModule {
    @NotNull
    private final AndroidProject myAndroidProject;
    @NotNull
    private final SyncModuleModels myModuleModels;
    @NotNull
    private final List<ModuleDependency> myModuleDependencies = new ArrayList<ModuleDependency>();
    @NotNull
    private final Map<String, Variant> myVariantsByName = new HashMap<String, Variant>();
    @NotNull
    public static final Pattern MODULE_ARTIFACT_ADDRESS_PATTERN = Pattern.compile("([^@]*)@@(.[^:]*)(::(.*))?");
    @Nullable
    private final NativeAndroidProject myNativeAndroidProject;

    AndroidModule(@NotNull AndroidProject androidProject, @NotNull SyncModuleModels moduleModels, @Nullable NativeAndroidProject nativeAndroidProject) {
        this.myAndroidProject = androidProject;
        this.myModuleModels = moduleModels;
        this.myNativeAndroidProject = nativeAndroidProject;
    }

    void addSelectedVariant(@NotNull Variant selectedVariant, @Nullable String abi) {
        this.myVariantsByName.put(selectedVariant.getName(), selectedVariant);
        AndroidArtifact artifact = selectedVariant.getMainArtifact();
        Dependencies dependencies = artifact.getDependencies();
        if (!dependencies.getLibraries().isEmpty()) {
            this.populateDependencies(dependencies, abi);
        } else {
            this.populateDependencies(artifact.getDependencyGraphs(), abi);
        }
    }

    private void populateDependencies(@NotNull Dependencies dependencies, @Nullable String abi) {
        for (AndroidLibrary library : dependencies.getLibraries()) {
            String project = library.getProject();
            if (project == null) continue;
            String id = Modules.createUniqueModuleId(Strings.nullToEmpty((String)library.getBuildId()), project);
            String variant = library.getProjectVariant();
            this.addModuleDependency(id, variant, abi);
        }
    }

    private void populateDependencies(@NotNull DependencyGraphs dependencyGraphs, @Nullable String abi) {
        for (GraphItem item : dependencyGraphs.getCompileDependencies()) {
            String address = item.getArtifactAddress();
            Matcher matcher = MODULE_ARTIFACT_ADDRESS_PATTERN.matcher(address);
            if (!matcher.matches()) continue;
            String buildId2 = matcher.group(1);
            String project = matcher.group(2);
            if (buildId2 == null || project == null) continue;
            String id = Modules.createUniqueModuleId(Strings.nullToEmpty((String)buildId2), project);
            String variant = matcher.group(4);
            this.addModuleDependency(id, variant, abi);
        }
    }

    private void addModuleDependency(@NotNull String id, @Nullable String variant, @Nullable String abi) {
        ModuleDependency dependency = new ModuleDependency(id, variant, abi);
        this.myModuleDependencies.add(dependency);
    }

    @NotNull
    AndroidProject getAndroidProject() {
        return this.myAndroidProject;
    }

    @Nullable
    NativeAndroidProject getNativeAndroidProject() {
        return this.myNativeAndroidProject;
    }

    @NotNull
    List<ModuleDependency> getModuleDependencies() {
        return this.myModuleDependencies;
    }

    @NotNull
    SyncModuleModels getModuleModels() {
        return this.myModuleModels;
    }

    boolean containsVariant(@NotNull String variantName) {
        return this.myVariantsByName.containsKey(variantName);
    }

    static class ModuleDependency {
        @NotNull
        final String id;
        @Nullable
        final String inheritedVariant;
        @Nullable
        final String inheritedAbi;

        ModuleDependency(@NotNull String id, @Nullable String inheritedVariant, @Nullable String inheritedAbi) {
            this.id = id;
            this.inheritedVariant = inheritedVariant;
            this.inheritedAbi = inheritedAbi;
        }
    }
}

