/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidModuleValidator;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleProcessor {
    public static final Key<GradleModuleModels> MODULE_GRADLE_MODELS_KEY = Key.create((String)"module.gradle.models");
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeModifiableModelsProvider myModelsProvider;
    @NotNull
    private final AndroidModuleValidator.Factory myModuleValidatorFactory;

    AndroidModuleProcessor(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        this(project, modelsProvider, new AndroidModuleValidator.Factory());
    }

    @VisibleForTesting
    AndroidModuleProcessor(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull AndroidModuleValidator.Factory moduleValidatorFactory) {
        this.myProject = project;
        this.myModelsProvider = modelsProvider;
        this.myModuleValidatorFactory = moduleValidatorFactory;
    }

    void processAndroidModels(@NotNull List<Module> androidModules) {
        AndroidModuleValidator moduleValidator = this.myModuleValidatorFactory.create(this.myProject);
        for (Module module : androidModules) {
            AndroidModuleModel androidModel = this.findAndroidModel(module);
            if (androidModel == null) continue;
            moduleValidator.validate(module, androidModel);
        }
        moduleValidator.fixAndReportFoundIssues();
    }

    @Nullable
    private AndroidModuleModel findAndroidModel(@NotNull Module module) {
        AndroidFacet facet = Facets.findFacet(module, this.myModelsProvider, AndroidFacet.ID);
        return facet != null ? AndroidModuleModel.get(facet) : null;
    }
}

