/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalModuleBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectBuildClasspathPojo;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.gradle.tooling.model.GradleProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class BuildScriptClasspathSetup {
    private static final Logger LOG = Logger.getInstance(BuildScriptClasspathSetup.class);

    public void setupBuildScriptClassPath(@NotNull SyncProjectModels projectModels, @NotNull Project project) {
        String projectBaseDir = project.getBasePath();
        if (projectBaseDir == null) {
            LOG.warn("Project path is null, skip BuildScriptClasspathSetup.");
            return;
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        if (manager == null) {
            LOG.warn("ExternalSystemManager is null, skip BuildScriptClasspathSetup.");
            return;
        }
        BuildScriptClasspathSetup.setGradleHomeDir(projectModels, project);
        AbstractExternalSystemLocalSettings localSettings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project);
        THashMap localProjectBuildClasspath = new THashMap(localSettings.getProjectBuildClasspath());
        ExternalProjectBuildClasspathPojo projectBuildClasspathPojo = (ExternalProjectBuildClasspathPojo)localProjectBuildClasspath.get(projectBaseDir);
        if (projectBuildClasspathPojo == null) {
            projectBuildClasspathPojo = new ExternalProjectBuildClasspathPojo(project.getName(), (List)ContainerUtil.newArrayList(), (Map)ContainerUtil.newHashMap());
            localProjectBuildClasspath.put(projectBaseDir, projectBuildClasspathPojo);
        }
        BuildScriptClasspathSetup.setProjectBuildClassPath(project, projectBuildClasspathPojo);
        BuildScriptClasspathSetup.setModuleBuildClasspath(projectBaseDir, projectModels, projectBuildClasspathPojo);
        localSettings.setProjectBuildClasspath((Map)localProjectBuildClasspath);
        if (!project.isDisposed()) {
            GradleBuildClasspathManager.getInstance((Project)project).reload();
        }
    }

    private static void setProjectBuildClassPath(@NotNull Project project, @NotNull ExternalProjectBuildClasspathPojo projectBuildClasspathPojo) {
        List libraries;
        GradleInstallationManager gradleInstallationManager;
        File gradleHome;
        LinkedHashSet gradleSdkLibraries = ContainerUtil.newLinkedHashSet();
        String linkedExternalProjectPath = project.getBasePath();
        if (linkedExternalProjectPath != null && (gradleHome = (gradleInstallationManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class)).getGradleHome(project, linkedExternalProjectPath)) != null && gradleHome.isDirectory() && (libraries = gradleInstallationManager.getClassRoots(project, linkedExternalProjectPath)) != null) {
            for (File library : libraries) {
                gradleSdkLibraries.add(FileUtil.toCanonicalPath((String)library.getPath()));
            }
        }
        projectBuildClasspathPojo.setProjectBuildClasspath((List)ContainerUtil.newArrayList((Iterable)gradleSdkLibraries));
    }

    private static void setModuleBuildClasspath(@NotNull String projectBaseDir, @NotNull SyncProjectModels projectModels, @NotNull ExternalProjectBuildClasspathPojo projectBuildClasspathPojo) {
        for (SyncModuleModels moduleModels : projectModels.getModuleModels()) {
            BuildScriptClasspathModel buildScriptClasspathModel = moduleModels.findModel(BuildScriptClasspathModel.class);
            List classpathEntries = buildScriptClasspathModel == null ? ContainerUtil.emptyList() : ContainerUtil.map((Collection)buildScriptClasspathModel.getClasspath(), model2 -> new BuildScriptClasspathData.ClasspathEntry(model2.getClasses(), model2.getSources(), model2.getJavadoc()));
            LinkedHashSet buildClasspathSources = ContainerUtil.newLinkedHashSet();
            LinkedHashSet buildClasspathClasses = ContainerUtil.newLinkedHashSet();
            for (BuildScriptClasspathData.ClasspathEntry classpathEntry : classpathEntries) {
                buildClasspathSources.addAll(classpathEntry.getSourcesFile().stream().map(entry -> FileUtil.toCanonicalPath((String)entry)).collect(Collectors.toList()));
                buildClasspathClasses.addAll(classpathEntry.getClassesFile().stream().map(entry -> FileUtil.toCanonicalPath((String)entry)).collect(Collectors.toList()));
            }
            List buildClasspath = (List)StreamEx.of((Collection)buildClasspathSources).append((Collection)buildClasspathClasses).collect(Collectors.toList());
            String externalModulePath = BuildScriptClasspathSetup.getModulePath(projectBaseDir, moduleModels);
            projectBuildClasspathPojo.getModulesBuildClasspath().put(externalModulePath, new ExternalModuleBuildClasspathPojo(externalModulePath, buildClasspath));
        }
    }

    @NotNull
    private static String getModulePath(@NotNull String projectBaseDir, @NotNull GradleModuleModels moduleModels) {
        GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
        assert (gradleProject != null);
        try {
            return ExternalSystemApiUtil.toCanonicalPath((String)gradleProject.getProjectDirectory().getCanonicalPath());
        }
        catch (IOException e) {
            return GradleUtil.getConfigPath((GradleProject)gradleProject, (String)projectBaseDir);
        }
    }

    private static void setGradleHomeDir(@NotNull SyncProjectModels projectModels, @NotNull Project project) {
        String linkedExternalProjectPath = project.getBasePath();
        if (linkedExternalProjectPath != null) {
            for (SyncModuleModels moduleModels : projectModels.getModuleModels()) {
                File gradleHomeDir;
                BuildScriptClasspathModel buildScriptClasspathModel = moduleModels.findModel(BuildScriptClasspathModel.class);
                if (buildScriptClasspathModel == null || (gradleHomeDir = buildScriptClasspathModel.getGradleHomeDir()) == null) continue;
                GradleLocalSettings.getInstance((Project)project).setGradleHome(linkedExternalProjectPath, gradleHomeDir.getPath());
                return;
            }
        }
    }
}

