/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.ng.CompositeBuildDataSetup;
import com.android.tools.idea.gradle.project.sync.ng.ExtraGradleSyncModelsManager;
import com.android.tools.idea.gradle.project.sync.ng.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.ModelNotFoundInCacheException;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.GradleModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.android.tools.idea.gradle.project.sync.setup.module.NdkModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.JavaModuleSetup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

class CachedProjectModelsSetup
extends ModuleSetup<CachedProjectModels> {
    @NotNull
    private final GradleModuleSetup myGradleModuleSetup;
    @NotNull
    private final AndroidModuleSetup myAndroidModuleSetup;
    @NotNull
    private final NdkModuleSetup myNdkModuleSetup;
    @NotNull
    private final JavaModuleSetup myJavaModuleSetup;
    @NotNull
    private final ModuleFinder.Factory myModuleFinderFactory;
    @NotNull
    private final CompositeBuildDataSetup myCompositeBuildDataSetup;
    @NotNull
    private final ExtraGradleSyncModelsManager myExtraModelsManager;

    CachedProjectModelsSetup(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ExtraGradleSyncModelsManager extraGradleSyncModelsManager, @NotNull GradleModuleSetup gradleModuleSetup, @NotNull AndroidModuleSetup androidModuleSetup, @NotNull NdkModuleSetup ndkModuleSetup, @NotNull JavaModuleSetup javaModuleSetup, @NotNull ModuleSetupContext.Factory moduleSetupFactory, @NotNull ModuleFinder.Factory moduleFinderFactory, @NotNull CompositeBuildDataSetup compositeBuildDataSetup) {
        super(project, modelsProvider, moduleSetupFactory);
        this.myExtraModelsManager = extraGradleSyncModelsManager;
        this.myGradleModuleSetup = gradleModuleSetup;
        this.myAndroidModuleSetup = androidModuleSetup;
        this.myNdkModuleSetup = ndkModuleSetup;
        this.myJavaModuleSetup = javaModuleSetup;
        this.myModuleFinderFactory = moduleFinderFactory;
        this.myCompositeBuildDataSetup = compositeBuildDataSetup;
    }

    @Override
    public void setUpModules(@NotNull CachedProjectModels projectModels, @NotNull ProgressIndicator indicator) throws ModelNotFoundInCacheException {
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode()) assert (!application.isDispatchThread());
        CachedProjectModelsSetup.notifyModuleConfigurationStarted(indicator);
        this.myCompositeBuildDataSetup.setupCompositeBuildData(projectModels, this.myProject);
        ArrayList<GradleFacet> gradleFacets = new ArrayList<GradleFacet>();
        ModuleFinder moduleFinder = this.myModuleFinderFactory.create(this.myProject);
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String gradlePath;
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null || !StringUtil.isNotEmpty((String)(gradlePath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH))) continue;
            moduleFinder.addModule(module, gradlePath);
            gradleFacets.add(gradleFacet);
        }
        ModuleSetup.SetupContextByModuleModel setupContextByModuleModel = new ModuleSetup.SetupContextByModuleModel();
        for (GradleFacet gradleFacet : gradleFacets) {
            String moduleName = gradleFacet.getModule().getName();
            CachedModuleModels moduleModelsCache = projectModels.findCacheForModule(moduleName);
            if (moduleModelsCache == null) continue;
            this.getModuleModelFromCache(gradleFacet, moduleModelsCache, moduleFinder, setupContextByModuleModel);
        }
        this.setupModuleModels(setupContextByModuleModel, this.myGradleModuleSetup, this.myNdkModuleSetup, this.myAndroidModuleSetup, this.myJavaModuleSetup, this.myExtraModelsManager, true);
    }

    private void getModuleModelFromCache(@NotNull GradleFacet gradleFacet, @NotNull CachedModuleModels cache2, @NotNull ModuleFinder moduleFinder, @NotNull ModuleSetup.SetupContextByModuleModel setupContexts) throws ModelNotFoundInCacheException {
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode()) assert (!application.isDispatchThread());
        Module module = gradleFacet.getModule();
        GradleModuleModel gradleModel = cache2.findModel(GradleModuleModel.class);
        if (gradleModel == null) {
            throw new ModelNotFoundInCacheException(GradleModuleModel.class);
        }
        ModuleSetupContext context = this.myModuleSetupFactory.create(module, this.myModelsProvider, moduleFinder, cache2);
        setupContexts.gradleSetupContexts.put(gradleModel, context);
        AndroidModuleModel androidModel = cache2.findModel(AndroidModuleModel.class);
        if (androidModel != null) {
            setupContexts.androidSetupContexts.put(androidModel, context);
            NdkModuleModel ndkModel = cache2.findModel(NdkModuleModel.class);
            if (ndkModel != null) {
                setupContexts.ndkSetupContexts.put(ndkModel, context);
            }
            return;
        }
        JavaModuleModel javaModel = cache2.findModel(JavaModuleModel.class);
        if (javaModel != null) {
            setupContexts.javaSetupContexts.put(javaModel, context);
        }
    }
}

