/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedProjectModels;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.GradleProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class CompositeBuildDataSetup {
    public void setupCompositeBuildData(@NotNull CachedProjectModels projectModels, @NotNull Project project) {
        CompositeBuildDataSetup.doSetupCompositeBuild(projectModels.getBuildParticipants(), project);
    }

    public void setupCompositeBuildData(@NotNull SyncProjectModels projectModels, @NotNull CachedProjectModels cache2, @NotNull Project project) {
        HashMap<String, BuildParticipant> compositeParticipants = new HashMap<String, BuildParticipant>();
        for (SyncModuleModels moduleModels : projectModels.getModuleModels()) {
            GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
            BuildIdentifier moduleBuildId = moduleModels.getBuildId();
            if (gradleProject == null || moduleBuildId == projectModels.getRootBuildId()) continue;
            try {
                String buildPath = ExternalSystemApiUtil.toCanonicalPath((String)moduleBuildId.getRootDir().getCanonicalPath());
                BuildParticipant buildParticipant = compositeParticipants.computeIfAbsent(buildPath, p -> {
                    BuildParticipant participant = new BuildParticipant();
                    GradleProject rootProject = gradleProject;
                    while (rootProject.getParent() != null) {
                        rootProject = rootProject.getParent();
                    }
                    participant.setRootProjectName(rootProject.getName());
                    cache2.addBuildParticipant(participant);
                    return participant;
                });
                buildParticipant.setRootPath(buildPath);
                buildParticipant.getProjects().add(ExternalSystemApiUtil.toCanonicalPath((String)gradleProject.getProjectDirectory().getCanonicalPath()));
            }
            catch (IOException e) {
                Logger.getInstance(CompositeBuildDataSetup.class).warn("Fails to construct the canonical path for module", (Throwable)e);
            }
        }
        CompositeBuildDataSetup.doSetupCompositeBuild(new ArrayList<BuildParticipant>(compositeParticipants.values()), project);
    }

    private static void doSetupCompositeBuild(@NotNull List<BuildParticipant> buildParticipants, @NotNull Project project) {
        String projectPath = project.getBasePath();
        if (projectPath == null) {
            return;
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(projectPath);
        if (projectSettings == null) {
            return;
        }
        GradleProjectSettings.CompositeBuild compositeBuild = new GradleProjectSettings.CompositeBuild();
        compositeBuild.setCompositeDefinitionSource(CompositeDefinitionSource.SCRIPT);
        compositeBuild.setCompositeParticipants(buildParticipants);
        projectSettings.setCompositeBuild(compositeBuild);
    }
}

