/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.ExtraGradleSyncAndroidModels;
import com.android.tools.idea.gradle.project.sync.ng.ExtraGradleSyncJavaModels;
import com.android.tools.idea.gradle.project.sync.ng.ExtraGradleSyncModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedModuleModels;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExtraGradleSyncModelsManager {
    @NotNull
    private final List<ExtraGradleSyncJavaModels> myJavaModels;
    @NotNull
    private final Set<Class<?>> myJavaModelTypes;
    @NotNull
    private final List<ExtraGradleSyncAndroidModels> myAndroidModels;
    @NotNull
    private final Set<Class<?>> myAndroidModelTypes;

    @NotNull
    public static ExtraGradleSyncModelsManager getInstance() {
        return (ExtraGradleSyncModelsManager)ServiceManager.getService(ExtraGradleSyncModelsManager.class);
    }

    public ExtraGradleSyncModelsManager() {
        this(Arrays.asList(ExtraGradleSyncJavaModels.getExtensions()), Arrays.asList(ExtraGradleSyncAndroidModels.getExtensions()));
    }

    ExtraGradleSyncModelsManager(@NotNull List<ExtraGradleSyncJavaModels> javaModels, @NotNull List<ExtraGradleSyncAndroidModels> androidModels) {
        this.myJavaModels = javaModels;
        this.myJavaModelTypes = new HashSet();
        for (ExtraGradleSyncJavaModels extraGradleSyncJavaModels : this.myJavaModels) {
            this.myJavaModelTypes.addAll(extraGradleSyncJavaModels.getModelTypes());
        }
        this.myAndroidModels = androidModels;
        this.myAndroidModelTypes = new HashSet();
        for (ExtraGradleSyncAndroidModels extraGradleSyncAndroidModels : this.myAndroidModels) {
            this.myAndroidModelTypes.addAll(extraGradleSyncAndroidModels.getModelTypes());
        }
    }

    @NotNull
    public Set<Class<?>> getAndroidModelTypes() {
        return this.myAndroidModelTypes;
    }

    @NotNull
    public Set<Class<?>> getJavaModelTypes() {
        return this.myJavaModelTypes;
    }

    public void applyJavaModelsToModule(@NotNull GradleModuleModels moduleModels, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        for (ExtraGradleSyncModels extraGradleSyncModels : this.myJavaModels) {
            extraGradleSyncModels.applyModelsToModule(moduleModels, module, modelsProvider);
        }
    }

    public void applyAndroidModelsToModule(@NotNull GradleModuleModels moduleModels, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        for (ExtraGradleSyncModels extraGradleSyncModels : this.myAndroidModels) {
            extraGradleSyncModels.applyModelsToModule(moduleModels, module, modelsProvider);
        }
    }

    public void addJavaModelsToCache(@NotNull Module module, @NotNull CachedModuleModels cache2) {
        for (ExtraGradleSyncModels extraGradleSyncModels : this.myJavaModels) {
            extraGradleSyncModels.addModelsToCache(module, cache2);
        }
    }

    public void addAndroidModelsToCache(@NotNull Module module, @NotNull CachedModuleModels cache2) {
        for (ExtraGradleSyncModels extraGradleSyncModels : this.myAndroidModels) {
            extraGradleSyncModels.addModelsToCache(module, cache2);
        }
    }
}

