/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.util.GradleUtil;

class ModuleFactory {
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeModifiableModelsProvider myModelsProvider;

    ModuleFactory(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        this.myProject = project;
        this.myModelsProvider = modelsProvider;
    }

    @NotNull
    Module createModule(@NotNull GradleModuleModels moduleModels) {
        GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
        assert (gradleProject != null);
        File imlFilePath = this.getModuleImlFilePath(gradleProject, moduleModels);
        Module newModule = this.myModelsProvider.newModule(imlFilePath.getPath(), StdModuleTypes.JAVA.getId());
        newModule.setOption("external.system.id", com.android.tools.idea.gradle.util.GradleUtil.GRADLE_SYSTEM_ID.getId());
        ModifiableRootModel rootModel = this.myModelsProvider.getModifiableRootModel(newModule);
        rootModel.inheritSdk();
        DependencyRemover dependencyRemover = new DependencyRemover(rootModel);
        for (OrderEntry orderEntry : rootModel.getOrderEntries()) {
            orderEntry.accept((RootPolicy)dependencyRemover, null);
        }
        return newModule;
    }

    @NotNull
    private File getModuleImlFilePath(@NotNull GradleProject gradleProject, @NotNull GradleModuleModels moduleModels) {
        String modulePath = this.getModulePath(gradleProject, moduleModels);
        String imlFileName = moduleModels.getModuleName() + ".iml";
        return new File(modulePath, imlFileName);
    }

    @NotNull
    private String getModulePath(@NotNull GradleProject gradleProject, @NotNull GradleModuleModels moduleModels) {
        GradleBuild gradleBuild = moduleModels.findModel(GradleBuild.class);
        if (gradleBuild != null) {
            File moduleDirPath = GradleProjectResolverUtil.getModuleDirPath((GradleBuild)gradleBuild, (String)gradleProject.getPath());
            if (moduleDirPath == null) {
                throw new IllegalStateException(String.format("Unable to find root directory for module '%1$s'", gradleProject.getName()));
            }
            return FileUtil.toCanonicalPath((String)moduleDirPath.getPath());
        }
        String projectPath = this.myProject.getBasePath();
        assert (projectPath != null);
        return FileUtil.toSystemDependentName((String)GradleUtil.getConfigPath((GradleProject)gradleProject, (String)projectPath));
    }

    private static class DependencyRemover
    extends RootPolicy<Object> {
        @NotNull
        private final ModifiableRootModel myRootModel;

        DependencyRemover(@NotNull ModifiableRootModel rootModel) {
            this.myRootModel = rootModel;
        }

        public Object visitModuleOrderEntry(@NotNull ModuleOrderEntry orderEntry, Object value2) {
            return this.remove((OrderEntry)orderEntry, value2);
        }

        public Object visitLibraryOrderEntry(@NotNull LibraryOrderEntry orderEntry, Object value2) {
            return this.remove((OrderEntry)orderEntry, value2);
        }

        private Object remove(OrderEntry orderEntry, Object value2) {
            this.myRootModel.removeOrderEntry(orderEntry);
            return value2;
        }
    }
}

