/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Strings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.tooling.model.GradleProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class ModuleNameGenerator {
    private static final int MAX_FILE_DEPTH = 3;

    static void deduplicateModuleNames(@NotNull SyncProjectModels projectModels, @NotNull Project project) {
        HashMap<SyncModuleModels, ModuleName> moduleModelsToModuleName = new HashMap<SyncModuleModels, ModuleName>();
        List<SyncModuleModels> moduleModels = projectModels.getModuleModels();
        for (SyncModuleModels moduleModel : moduleModels) {
            GradleProject gradleProject = moduleModel.findModel(GradleProject.class);
            if (gradleProject == null) continue;
            moduleModelsToModuleName.put(moduleModel, new ModuleName(gradleProject.getProjectDirectory().getPath(), moduleModel.getModuleName()));
        }
        ModuleNameGenerator.doDeduplicate(moduleModelsToModuleName.values(), project);
        for (SyncModuleModels moduleModel : moduleModels) {
            ModuleName moduleName = (ModuleName)moduleModelsToModuleName.get(moduleModel);
            if (moduleName == null) continue;
            moduleModel.setModuleName(moduleName.name);
        }
    }

    @NotNull
    public static Map<String, String> getModuleNameByModulePath(@NotNull Collection<String> modulePaths, @NotNull Project project) {
        Map<String, ModuleName> moduleNameByModulePath = modulePaths.stream().collect(Collectors.toMap(p -> p, p -> new ModuleName((String)p, new File((String)p).getName())));
        ModuleNameGenerator.doDeduplicate(moduleNameByModulePath.values(), project);
        return moduleNameByModulePath.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((ModuleName)e.getValue()).name));
    }

    private static void doDeduplicate(@NotNull Collection<ModuleName> moduleNames, @NotNull Project project) {
        Map<String, List<ModuleName>> moduleNamesByName = moduleNames.stream().collect(Collectors.groupingBy(m -> ((ModuleName)m).name));
        GradleProjectSettings settings = GradleUtil.getGradleProjectSettings(project);
        char delimiter = settings != null && settings.isUseQualifiedModuleNames() ? (char)'.' : '-';
        for (List<ModuleName> names : moduleNamesByName.values()) {
            if (names.size() <= 1) continue;
            ModuleNameGenerator.doDeduplicate(names, delimiter);
        }
    }

    private static void doDeduplicate(@NotNull List<ModuleName> moduleNames, char delimiter) {
        Set uniqueNames;
        HashMap moduleNameToNameCandidates = new HashMap();
        for (ModuleName moduleName : moduleNames) {
            List pathParts = FileUtil.splitPath((String)FileUtil.toSystemDependentName((String)moduleName.moduleDirectory));
            ArrayList<String> nameCandidates = new ArrayList<String>();
            moduleNameToNameCandidates.put(moduleName, nameCandidates);
            StringBuilder nameBuilder = new StringBuilder(moduleName.name);
            int i2 = pathParts.size() - 2;
            for (int j = 0; i2 >= 0 && j < 3; --i2, ++j) {
                String prefix = (String)pathParts.get(i2);
                if (Strings.isNullOrEmpty((String)prefix)) continue;
                nameBuilder.insert(0, prefix + delimiter);
                nameCandidates.add(nameBuilder.toString());
            }
        }
        int nameIndex = 0;
        do {
            for (ModuleName moduleName : moduleNames) {
                List nameCandidates = (List)moduleNameToNameCandidates.get(moduleName);
                if (nameCandidates == null || nameIndex >= nameCandidates.size()) continue;
                moduleName.name = (String)nameCandidates.get(nameIndex);
            }
        } while ((uniqueNames = moduleNames.stream().map(m -> ((ModuleName)m).name).collect(Collectors.toSet())).size() < moduleNames.size() && ++nameIndex < 3);
    }

    private static class ModuleName {
        @NotNull
        private String moduleDirectory;
        @NotNull
        private String name;

        ModuleName(@NotNull String moduleDirectory, @NotNull String baseName) {
            this.moduleDirectory = moduleDirectory;
            this.name = baseName;
        }
    }
}

