/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.ide.common.gradle.model.IdeNativeAndroidProject;
import com.android.ide.common.gradle.model.IdeNativeAndroidProjectImpl;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModelFactory;
import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.common.VariantSelector;
import com.android.tools.idea.gradle.project.sync.ng.AndroidModelFactory;
import com.android.tools.idea.gradle.project.sync.ng.AndroidModuleProcessor;
import com.android.tools.idea.gradle.project.sync.ng.BuildScriptClasspathSetup;
import com.android.tools.idea.gradle.project.sync.ng.CachedProjectModelsSetup;
import com.android.tools.idea.gradle.project.sync.ng.CompositeBuildDataSetup;
import com.android.tools.idea.gradle.project.sync.ng.ExtraGradleSyncModelsManager;
import com.android.tools.idea.gradle.project.sync.ng.GradleSyncProgress;
import com.android.tools.idea.gradle.project.sync.ng.ModuleFactory;
import com.android.tools.idea.gradle.project.sync.ng.ObsoleteModuleDisposer;
import com.android.tools.idea.gradle.project.sync.ng.ProjectDataNodeSetup;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModelsSetup;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.ModelNotFoundInCacheException;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlyProjectModelsSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.GradleModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.android.tools.idea.gradle.project.sync.setup.module.NdkModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.android.AndroidVariantChangeModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.JavaModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.ndk.NdkVariantChangeModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectCleanup;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleSetup<T> {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final IdeModifiableModelsProvider myModelsProvider;
    @NotNull
    protected final ModuleSetupContext.Factory myModuleSetupFactory;

    public ModuleSetup(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleSetupContext.Factory moduleSetupFactory) {
        this.myProject = project;
        this.myModelsProvider = modelsProvider;
        this.myModuleSetupFactory = moduleSetupFactory;
    }

    public abstract void setUpModules(@NotNull T var1, @NotNull ProgressIndicator var2) throws ModelNotFoundInCacheException;

    protected static void notifyModuleConfigurationStarted(@NotNull ProgressIndicator indicator) {
        GradleSyncProgress.notifyProgress(indicator, "Configuring modules");
    }

    protected void setupModuleModels(@NotNull SetupContextByModuleModel setupContextByModuleModel, @NotNull GradleModuleSetup gradleModuleSetup, @NotNull NdkModuleSetup ndkModuleSetup, @NotNull AndroidModuleSetup androidModuleSetup, @NotNull JavaModuleSetup javaModuleSetup, @NotNull ExtraGradleSyncModelsManager extraModelsManager, boolean syncSkipped) {
        GradleModuleModels gradleModels;
        ModuleSetupContext setupContext;
        for (Map.Entry<GradleModuleModel, ModuleSetupContext> entry : setupContextByModuleModel.gradleSetupContexts.entrySet()) {
            gradleModuleSetup.setUpModule(entry.getValue().getModule(), entry.getValue().getIdeModelsProvider(), entry.getKey());
        }
        for (Map.Entry<ModuleModel, ModuleSetupContext> entry : setupContextByModuleModel.ndkSetupContexts.entrySet()) {
            ndkModuleSetup.setUpModule(entry.getValue(), entry.getKey(), syncSkipped);
        }
        for (Map.Entry<ModuleModel, ModuleSetupContext> entry : setupContextByModuleModel.androidSetupContexts.entrySet()) {
            setupContext = entry.getValue();
            androidModuleSetup.setUpModule(entry.getValue(), entry.getKey(), syncSkipped);
            gradleModels = setupContext.getGradleModels();
            if (gradleModels == null) continue;
            extraModelsManager.applyAndroidModelsToModule(setupContext.getGradleModels(), setupContext.getModule(), this.myModelsProvider);
        }
        for (Map.Entry<ModuleModel, ModuleSetupContext> entry : setupContextByModuleModel.javaSetupContexts.entrySet()) {
            setupContext = entry.getValue();
            javaModuleSetup.setUpModule(setupContext, entry.getKey(), syncSkipped);
            gradleModels = setupContext.getGradleModels();
            if (gradleModels == null) continue;
            extraModelsManager.applyJavaModelsToModule(gradleModels, setupContext.getModule(), this.myModelsProvider);
        }
    }

    protected static class SetupContextByModuleModel {
        final Map<AndroidModuleModel, ModuleSetupContext> androidSetupContexts = new HashMap<AndroidModuleModel, ModuleSetupContext>();
        final Map<NdkModuleModel, ModuleSetupContext> ndkSetupContexts = new HashMap<NdkModuleModel, ModuleSetupContext>();
        final Map<JavaModuleModel, ModuleSetupContext> javaSetupContexts = new HashMap<JavaModuleModel, ModuleSetupContext>();
        final Map<GradleModuleModel, ModuleSetupContext> gradleSetupContexts = new HashMap<GradleModuleModel, ModuleSetupContext>();

        protected SetupContextByModuleModel() {
        }
    }

    static class Factory {
        Factory() {
        }

        @NotNull
        SyncProjectModelsSetup createForFullSync(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
            IdeDependenciesFactory dependenciesFactory = new IdeDependenciesFactory();
            return new SyncProjectModelsSetup(project, modelsProvider, dependenciesFactory, ExtraGradleSyncModelsManager.getInstance(), new ModuleFactory(project, modelsProvider), new GradleModuleSetup(), new AndroidModuleSetup(), new NdkModuleSetup(), new JavaModuleSetup(), new AndroidModuleProcessor(project, modelsProvider), new AndroidModelFactory(new VariantSelector(), dependenciesFactory), new ProjectCleanup(), new ObsoleteModuleDisposer(project, modelsProvider), new CachedProjectModels.Factory(), (IdeNativeAndroidProject.Factory)new IdeNativeAndroidProjectImpl.FactoryImpl(), new JavaModuleModelFactory(), new ProjectDataNodeSetup(), new ModuleSetupContext.Factory(), new ModuleFinder.Factory(), new CompositeBuildDataSetup(), new BuildScriptClasspathSetup());
        }

        @NotNull
        CachedProjectModelsSetup createForCachedSync(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
            return new CachedProjectModelsSetup(project, modelsProvider, ExtraGradleSyncModelsManager.getInstance(), new GradleModuleSetup(), new AndroidModuleSetup(), new NdkModuleSetup(), new JavaModuleSetup(), new ModuleSetupContext.Factory(), new ModuleFinder.Factory(), new CompositeBuildDataSetup());
        }

        @NotNull
        VariantOnlyProjectModelsSetup createForVariantOnlySync(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
            return new VariantOnlyProjectModelsSetup(project, modelsProvider, new ModuleSetupContext.Factory(), new IdeDependenciesFactory(), new CachedProjectModels.Loader(), new AndroidVariantChangeModuleSetup(), new NdkVariantChangeModuleSetup());
        }
    }
}

