/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.java.model.ArtifactModel;
import com.android.java.model.JavaProject;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectBuildFileChecksums;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModelFactory;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.GradleSync;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.PsdModuleModels;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutionCallback;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutor;
import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncResultHandler;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedProjectModels;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewGradleSync
implements GradleSync {
    private static final Logger LOG = Logger.getInstance(NewGradleSync.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleSyncMessages mySyncMessages;
    @NotNull
    private final SyncExecutor mySyncExecutor;
    @NotNull
    private final SyncResultHandler myResultHandler;
    @NotNull
    private final ProjectBuildFileChecksums.Loader myBuildFileChecksumsLoader;
    @NotNull
    private final CachedProjectModels.Loader myProjectModelsCacheLoader;
    @NotNull
    private final SyncExecutionCallback.Factory myCallbackFactory;
    public static final String NOT_ELIGIBLE_FOR_SINGLE_VARIANT_SYNC = "not.eligible.for.single.variant.sync";

    public static boolean isLevel4Model() {
        return (Boolean)StudioFlags.L4_DEPENDENCY_MODEL.get();
    }

    public static boolean isEnabled(@NotNull Project project) {
        return (Boolean)StudioFlags.NEW_SYNC_INFRA_ENABLED.get() != false || NewGradleSync.isSingleVariantSync(project);
    }

    public static boolean isSingleVariantSync(@NotNull Project project) {
        return (Boolean)StudioFlags.SINGLE_VARIANT_SYNC_ENABLED.get() != false || GradleExperimentalSettings.getInstance().USE_SINGLE_VARIANT_SYNC && !PropertiesComponent.getInstance((Project)project).getBoolean(NOT_ELIGIBLE_FOR_SINGLE_VARIANT_SYNC);
    }

    public static boolean isCompoundSync(@NotNull Project project) {
        return (Boolean)StudioFlags.COMPOUND_SYNC_ENABLED.get() != false && NewGradleSync.isEnabled(project) && NewGradleSync.isSingleVariantSync(project);
    }

    public static boolean isShippedSync(@NotNull Project project) {
        return (Boolean)StudioFlags.SHIPPED_SYNC_ENABLED.get() != false && NewGradleSync.isEnabled(project) && GradleProjectInfo.getInstance(project).isNewProject();
    }

    public NewGradleSync(@NotNull Project project) {
        this(project, GradleSyncMessages.getInstance(project), new SyncExecutor(project), new SyncResultHandler(project), new ProjectBuildFileChecksums.Loader(), new CachedProjectModels.Loader(), new SyncExecutionCallback.Factory());
    }

    @VisibleForTesting
    NewGradleSync(@NotNull Project project, @NotNull GradleSyncMessages syncMessages, @NotNull SyncExecutor syncExecutor, @NotNull SyncResultHandler resultHandler, @NotNull ProjectBuildFileChecksums.Loader buildFileChecksumsLoader, @NotNull CachedProjectModels.Loader projectModelsCacheLoader, @NotNull SyncExecutionCallback.Factory callbackFactory) {
        this.myProject = project;
        this.mySyncMessages = syncMessages;
        this.mySyncExecutor = syncExecutor;
        this.myResultHandler = resultHandler;
        this.myBuildFileChecksumsLoader = buildFileChecksumsLoader;
        this.myProjectModelsCacheLoader = projectModelsCacheLoader;
        this.myCallbackFactory = callbackFactory;
    }

    @Override
    public void sync(@NotNull GradleSyncInvoker.Request request, @Nullable GradleSyncListener listener2) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            this.mySyncMessages.removeAllMessages();
            this.sync(request, (ProgressIndicator)new EmptyProgressIndicator(), listener2);
            return;
        }
        Task task = this.createSyncTask(request, listener2);
        application.invokeLater(() -> {
            this.mySyncMessages.removeAllMessages();
            task.queue();
        }, ModalityState.defaultModalityState());
    }

    @VisibleForTesting
    @NotNull
    Task createSyncTask(final @NotNull GradleSyncInvoker.Request request, final @Nullable GradleSyncListener listener2) {
        Object syncTask;
        String title = "Gradle Sync";
        ProgressExecutionMode executionMode = request.getProgressExecutionMode();
        switch (executionMode) {
            case MODAL_SYNC: {
                syncTask = new Task.Modal(this.myProject, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        NewGradleSync.this.sync(request, indicator, listener2);
                    }
                };
                break;
            }
            case IN_BACKGROUND_ASYNC: {
                syncTask = new Task.Backgroundable(this.myProject, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        NewGradleSync.this.sync(request, indicator, listener2);
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException(executionMode + " is not a supported execution mode");
            }
        }
        return syncTask;
    }

    private void sync(@NotNull GradleSyncInvoker.Request request, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) {
        PostSyncProjectSetup.Request setupRequest = NewGradleSync.createPostSyncRequest(request);
        if (this.trySyncWithCachedGradleModels(setupRequest, indicator, syncListener)) {
            return;
        }
        request.useCachedGradleModels = false;
        setupRequest.usingCachedGradleModels = false;
        boolean isVariantOnlySync = request.variantOnlySyncOptions != null;
        boolean isCompoundSync = NewGradleSync.isCompoundSync(this.myProject) && request.generateSourcesOnSuccess;
        SyncExecutionCallback callback2 = this.myCallbackFactory.create();
        callback2.doWhenRejected(() -> this.myResultHandler.onSyncFailed(callback2, syncListener));
        if (isCompoundSync) {
            callback2.doWhenDone(() -> this.myResultHandler.onCompoundSyncModels(callback2, setupRequest, indicator, syncListener, isVariantOnlySync));
        } else if (isVariantOnlySync) {
            callback2.doWhenDone(() -> this.myResultHandler.onVariantOnlySyncFinished(callback2, setupRequest, indicator, syncListener));
        } else {
            callback2.doWhenDone(() -> this.myResultHandler.onSyncFinished(callback2, setupRequest, indicator, syncListener));
        }
        this.mySyncExecutor.syncProject(indicator, callback2, request.variantOnlySyncOptions, syncListener, request, this.myResultHandler, isCompoundSync);
    }

    private boolean trySyncWithCachedGradleModels(@NotNull PostSyncProjectSetup.Request setupRequest, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) {
        if (!setupRequest.usingCachedGradleModels) {
            return false;
        }
        try {
            ProjectBuildFileChecksums buildFileChecksums = this.myBuildFileChecksumsLoader.loadFromDisk(this.myProject);
            if (buildFileChecksums == null || !buildFileChecksums.canUseCachedData()) {
                return false;
            }
            CachedProjectModels projectModelsCache = this.myProjectModelsCacheLoader.loadFromDisk(this.myProject);
            if (projectModelsCache == null) {
                return false;
            }
            if (NewGradleSync.areCachedFilesMissing(this.myProject)) {
                Logger.getInstance(NewGradleSync.class).info("Cached library files are missing from disk. Performing a Gradle Sync.");
                return false;
            }
            setupRequest.generateSourcesAfterSync = true;
            setupRequest.lastSyncTimestamp = buildFileChecksums.getLastGradleSyncTimestamp();
            ExternalSystemTaskId taskId = PostSyncProjectSetup.createProjectSetupFromCacheTaskWithStartMessage(this.myProject);
            try {
                this.myResultHandler.onSyncSkipped(projectModelsCache, setupRequest, indicator, syncListener, taskId);
            }
            catch (Throwable e) {
                this.mySyncExecutor.generateFailureEvent(taskId);
                Logger.getInstance(NewGradleSync.class).warn("Restoring project state from cache failed. Performing a Gradle Sync.", e);
                return false;
            }
        }
        catch (Throwable ex) {
            LOG.error("Sync with cached Gradle models failed.", ex);
            return false;
        }
        return true;
    }

    public static boolean areCachedFilesMissing(@NotNull Project project) {
        Ref missingFileFound = Ref.create((Object)false);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            rootManager.orderEntries().withoutModuleSourceEntries().withoutDepModules().forEach(entry -> {
                for (OrderRootType type : OrderRootType.getAllTypes()) {
                    List<String> expectedUrls = Arrays.asList(entry.getUrls(type));
                    if (type.equals((Object)OrderRootType.CLASSES)) {
                        if (!expectedUrls.stream().noneMatch(url -> VirtualFileManager.getInstance().findFileByUrl(url) != null)) continue;
                        missingFileFound.set((Object)true);
                        return false;
                    }
                    if (!expectedUrls.stream().anyMatch(url -> VirtualFileManager.getInstance().findFileByUrl(url) == null)) continue;
                    missingFileFound.set((Object)true);
                    return false;
                }
                return true;
            });
            if (!((Boolean)missingFileFound.get()).booleanValue()) continue;
            return true;
        }
        return (Boolean)missingFileFound.get();
    }

    private static PostSyncProjectSetup.Request createPostSyncRequest(@NotNull GradleSyncInvoker.Request request) {
        PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
        setupRequest.usingCachedGradleModels = request.useCachedGradleModels;
        setupRequest.generateSourcesAfterSync = request.generateSourcesOnSuccess;
        setupRequest.cleanProjectAfterSync = request.cleanProject;
        NewGradleSync.setSkipAndroidPluginUpgrade(request, setupRequest);
        return setupRequest;
    }

    private static void setSkipAndroidPluginUpgrade(@NotNull GradleSyncInvoker.Request syncRequest, @NotNull PostSyncProjectSetup.Request setupRequest) {
        if (ApplicationManager.getApplication().isUnitTestMode() && syncRequest.skipAndroidPluginUpgrade) {
            setupRequest.skipAndroidPluginUpgrade = true;
        }
    }

    @Override
    @NotNull
    public List<GradleModuleModels> fetchGradleModels(@NotNull ProgressIndicator indicator) {
        List<SyncModuleModels> models = this.mySyncExecutor.fetchGradleModels(indicator);
        ImmutableList.Builder builder = ImmutableList.builder();
        IdeDependenciesFactory dependenciesFactory = new IdeDependenciesFactory();
        JavaModuleModelFactory javaModelFactory = new JavaModuleModelFactory();
        String emptyVariantName = "";
        for (SyncModuleModels moduleModels : models) {
            GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
            if (gradleProject == null) continue;
            String name = moduleModels.getModuleName();
            PsdModuleModels newModels = new PsdModuleModels(name);
            builder.add((Object)newModels);
            GradleScript buildScript = null;
            try {
                buildScript = gradleProject.getBuildScript();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            AndroidProject androidProject = moduleModels.findModel(AndroidProject.class);
            String agpVersion = androidProject != null ? androidProject.getModelVersion() : null;
            File buildFilePath = buildScript != null ? buildScript.getSourceFile() : null;
            GradleModuleModel gradleModel = new GradleModuleModel(name, gradleProject, Collections.emptyList(), buildFilePath, null, agpVersion);
            newModels.addModel(GradleModuleModel.class, gradleModel);
            File moduleRootPath = gradleProject.getProjectDirectory();
            if (androidProject != null) {
                AndroidModuleModel androidModel = new AndroidModuleModel(name, moduleRootPath, androidProject, emptyVariantName, dependenciesFactory);
                newModels.addModel(AndroidModuleModel.class, androidModel);
                continue;
            }
            JavaProject javaProject = moduleModels.findModel(JavaProject.class);
            if (javaProject != null) {
                JavaModuleModel javaModel = javaModelFactory.create(moduleRootPath, gradleProject, javaProject);
                newModels.addModel(JavaModuleModel.class, javaModel);
                continue;
            }
            ArtifactModel jarAarProject = moduleModels.findModel(ArtifactModel.class);
            if (gradleProject.getPath().equals(":") || jarAarProject == null) continue;
            JavaModuleModel javaModel = javaModelFactory.create(moduleRootPath, gradleProject, jarAarProject);
            newModels.addModel(JavaModuleModel.class, javaModel);
        }
        return builder.build();
    }
}

