/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.ng.CachedProjectModelsSetup;
import com.android.tools.idea.gradle.project.sync.ng.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModelsSetup;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.ModelNotFoundInCacheException;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlyProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlyProjectModelsSetup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

abstract class ProjectSetup {
    ProjectSetup() {
    }

    abstract void setUpProject(@NotNull SyncProjectModels var1, @NotNull ProgressIndicator var2);

    abstract void setUpProject(@NotNull CachedProjectModels var1, @NotNull ProgressIndicator var2) throws ModelNotFoundInCacheException;

    abstract void setUpProject(@NotNull VariantOnlyProjectModels var1, @NotNull ProgressIndicator var2);

    abstract void commit();

    @VisibleForTesting
    static class ProjectSetupImpl
    extends ProjectSetup {
        @NotNull
        private final Project myProject;
        @NotNull
        private final IdeModifiableModelsProvider myModelsProvider;
        @NotNull
        private final ModuleSetup.Factory myModuleSetupFactory;

        ProjectSetupImpl(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleSetup.Factory moduleSetupFactory) {
            this.myProject = project;
            this.myModelsProvider = modelsProvider;
            this.myModuleSetupFactory = moduleSetupFactory;
        }

        @Override
        void setUpProject(@NotNull SyncProjectModels projectModels, @NotNull ProgressIndicator indicator) {
            SyncProjectModelsSetup moduleSetup = this.myModuleSetupFactory.createForFullSync(this.myProject, this.myModelsProvider);
            try {
                moduleSetup.setUpModules(projectModels, indicator);
            }
            catch (Throwable e) {
                this.disposeChanges();
                throw e;
            }
        }

        @Override
        void setUpProject(@NotNull CachedProjectModels projectModels, @NotNull ProgressIndicator indicator) throws ModelNotFoundInCacheException {
            CachedProjectModelsSetup moduleSetup = this.myModuleSetupFactory.createForCachedSync(this.myProject, this.myModelsProvider);
            try {
                moduleSetup.setUpModules(projectModels, indicator);
            }
            catch (Throwable e) {
                this.disposeChanges();
                throw e;
            }
        }

        @Override
        void setUpProject(@NotNull VariantOnlyProjectModels projectModels, @NotNull ProgressIndicator indicator) {
            VariantOnlyProjectModelsSetup moduleSetup = this.myModuleSetupFactory.createForVariantOnlySync(this.myProject, this.myModelsProvider);
            try {
                moduleSetup.setUpModules(projectModels, indicator);
            }
            catch (Throwable e) {
                this.disposeChanges();
                throw e;
            }
        }

        @Override
        void commit() {
            try {
                ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

                    public void execute() {
                        myModelsProvider.commit();
                    }
                });
            }
            catch (Throwable e) {
                ProjectSetupImpl.getLog().warn("Exception thrown while committing project changes", e);
                this.disposeChanges();
                throw e;
            }
        }

        private void disposeChanges() {
            ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

                public void execute() {
                    try {
                        myModelsProvider.dispose();
                    }
                    catch (Throwable e) {
                        ProjectSetupImpl.getLog().warn("Failed to dispose changes", e);
                    }
                }
            });
        }

        @NotNull
        private static Logger getLog() {
            return Logger.getInstance(ProjectSetup.class);
        }
    }

    static class Factory {
        Factory() {
        }

        @NotNull
        ProjectSetup create(@NotNull Project project) {
            return new ProjectSetupImpl(project, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project), new ModuleSetup.Factory());
        }
    }
}

