/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.ModelBuilderParameter;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeVariantAbi;
import com.android.builder.model.NativeVariantInfo;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.ng.AndroidModule;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariants;
import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectedVariantChooser
implements Serializable {
    void chooseSelectedVariants(@NotNull List<SyncModuleModels> projectModels, @NotNull BuildController controller, @NotNull SelectedVariants selectedVariants2, boolean shouldGenerateSources) {
        HashMap<String, AndroidModule> modulesById = new HashMap<String, AndroidModule>();
        LinkedList<String> allModules = new LinkedList<String>();
        HashSet<String> visitedModules = new HashSet<String>();
        for (SyncModuleModels moduleModels : projectModels) {
            AndroidProject androidProject = moduleModels.findModel(AndroidProject.class);
            GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
            if (gradleProject == null || androidProject == null || !androidProject.getVariants().isEmpty()) continue;
            NativeAndroidProject nativeAndroidProject = moduleModels.findModel(NativeAndroidProject.class);
            AndroidModule module = new AndroidModule(androidProject, moduleModels, nativeAndroidProject);
            String id = Modules.createUniqueModuleId(gradleProject);
            modulesById.put(id, module);
            if (androidProject.getProjectType() == 0) {
                allModules.addFirst(id);
                continue;
            }
            allModules.addLast(id);
        }
        for (String moduleId : allModules) {
            if (visitedModules.contains(moduleId)) continue;
            visitedModules.add(moduleId);
            AndroidModule module = (AndroidModule)modulesById.get(moduleId);
            Objects.requireNonNull(module);
            Variant variant = SelectedVariantChooser.selectVariantForAppOrLeaf(module, controller, selectedVariants2, moduleId, shouldGenerateSources);
            if (variant == null) continue;
            String abi = SelectedVariantChooser.syncAndAddNativeVariantAbi(module, controller, variant.getName(), selectedVariants2.getSelectedAbi(moduleId));
            module.addSelectedVariant(variant, abi);
            SelectedVariantChooser.selectVariantForChildModules(module, controller, modulesById, visitedModules, shouldGenerateSources);
        }
    }

    private static void selectVariantForChildModules(@NotNull AndroidModule parentModule, @NotNull BuildController controller, @NotNull Map<String, AndroidModule> libModulesById, @NotNull Set<String> visitedModules, boolean shouldGenerateSources) {
        for (AndroidModule.ModuleDependency dependency : parentModule.getModuleDependencies()) {
            Variant childVariant;
            AndroidModule childModule;
            String childModuleId = dependency.id;
            visitedModules.add(childModuleId);
            String childVariantName = dependency.inheritedVariant;
            if (childVariantName == null || (childModule = libModulesById.get(childModuleId)) == null || childModule.containsVariant(childVariantName)) continue;
            String childAbiName = null;
            if (childModule.getNativeAndroidProject() != null) {
                childAbiName = SelectedVariantChooser.syncAndAddNativeVariantAbi(childModule, controller, childVariantName, dependency.inheritedAbi);
            }
            if ((childVariant = SelectedVariantChooser.syncAndAddVariant(childVariantName, childModule.getModuleModels(), controller, shouldGenerateSources)) == null) continue;
            childModule.addSelectedVariant(childVariant, childAbiName);
            SelectedVariantChooser.selectVariantForChildModules(childModule, controller, libModulesById, visitedModules, shouldGenerateSources);
        }
    }

    @Nullable
    private static Variant selectVariantForAppOrLeaf(@NotNull AndroidModule androidModule, @NotNull BuildController controller, @NotNull SelectedVariants selectedVariants2, @NotNull String moduleId, boolean shouldGenerateSources) {
        String variant = selectedVariants2.getSelectedVariant(moduleId);
        Collection variantNames = androidModule.getAndroidProject().getVariantNames();
        if (variant == null || !variantNames.contains(variant)) {
            try {
                variant = androidModule.getAndroidProject().getDefaultVariant();
            }
            catch (UnsupportedMethodException e) {
                variant = SelectedVariantChooser.getDefaultOrFirstItem(variantNames, "debug");
            }
        }
        return variant != null ? SelectedVariantChooser.syncAndAddVariant(variant, androidModule.getModuleModels(), controller, shouldGenerateSources) : null;
    }

    @Nullable
    public static String getDefaultOrFirstItem(@NotNull Collection<String> names, @NotNull String defaultValue) {
        if (names.isEmpty()) {
            return null;
        }
        return names.contains(defaultValue) ? defaultValue : Collections.min(names, String::compareTo);
    }

    @Nullable
    private static Variant syncAndAddVariant(@NotNull String variantName, @NotNull SyncModuleModels moduleModels, @NotNull BuildController controller, boolean shouldGenerateSources) {
        GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
        Objects.requireNonNull(gradleProject);
        Variant variant = (Variant)controller.findModel((Model)gradleProject, Variant.class, ModelBuilderParameter.class, parameter -> {
            parameter.setVariantName(variantName);
            parameter.setShouldGenerateSources(shouldGenerateSources);
        });
        if (variant != null) {
            moduleModels.addModel(Variant.class, variant);
        }
        return variant;
    }

    @Nullable
    private static String syncAndAddNativeVariantAbi(@NotNull AndroidModule androidModule, @NotNull BuildController controller, @NotNull String variant, @Nullable String abi) {
        NativeAndroidProject nativeAndroidProject = androidModule.getNativeAndroidProject();
        if (nativeAndroidProject != null) {
            List abiNames;
            try {
                abiNames = ((NativeVariantInfo)nativeAndroidProject.getVariantInfos().get(variant)).getAbiNames();
            }
            catch (UnsupportedMethodException e) {
                return null;
            }
            if (abi == null || !abiNames.contains(abi)) {
                abi = SelectedVariantChooser.getDefaultOrFirstItem(abiNames, "x86");
            }
            if (abi != null) {
                String abiToSelect = abi;
                SyncModuleModels moduleModels = androidModule.getModuleModels();
                GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
                Objects.requireNonNull(gradleProject);
                NativeVariantAbi variantAbi = (NativeVariantAbi)controller.findModel((Model)gradleProject, NativeVariantAbi.class, ModelBuilderParameter.class, parameter -> {
                    parameter.setVariantName(variant);
                    parameter.setAbiName(abiToSelect);
                });
                if (variantAbi != null) {
                    moduleModels.addModel(NativeVariantAbi.class, variantAbi);
                }
                return abiToSelect;
            }
        }
        return null;
    }
}

