/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacetConfiguration;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariants;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectedVariantCollector {
    @NotNull
    private final Project myProject;

    public SelectedVariantCollector(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public SelectedVariants collectSelectedVariants() {
        SelectedVariants selectedVariants2 = new SelectedVariants();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            SelectedVariant variant = this.findSelectedVariant(module);
            if (variant == null) continue;
            selectedVariants2.addSelectedVariant(variant.moduleId, variant.variantName, variant.abiName);
        }
        return selectedVariants2;
    }

    @VisibleForTesting
    @Nullable
    SelectedVariant findSelectedVariant(@NotNull Module module) {
        GradleModuleModel gradleModel;
        GradleFacet gradleFacet = GradleFacet.getInstance(module);
        if (gradleFacet != null && (gradleModel = gradleFacet.getGradleModuleModel()) != null) {
            File rootFolder = gradleModel.getRootFolderPath();
            String projectPath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            NdkModuleModel ndkModuleModel = NdkModuleModel.get(module);
            NdkFacet ndkFacet = NdkFacet.getInstance(module);
            if (ndkFacet != null && ndkModuleModel != null) {
                String ndkVariantName = ((NdkFacetConfiguration)ndkFacet.getConfiguration()).SELECTED_BUILD_VARIANT;
                return new SelectedVariant(rootFolder, projectPath, ndkModuleModel.getVariantName(ndkVariantName), ndkModuleModel.getAbiName(ndkVariantName));
            }
            if (androidFacet != null) {
                return new SelectedVariant(rootFolder, projectPath, androidFacet.getProperties().SELECTED_BUILD_VARIANT, null);
            }
        }
        return null;
    }

    static class SelectedVariant {
        @NotNull
        final String moduleId;
        @NotNull
        final String variantName;
        @Nullable
        final String abiName;

        SelectedVariant(@NotNull File rootFolderPath, @NotNull String gradlePath, @NotNull String variantName, @Nullable String abiName) {
            this.moduleId = Modules.createUniqueModuleId(rootFolderPath, gradlePath);
            this.variantName = variantName;
            this.abiName = abiName;
        }
    }
}

