/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.ng.SyncActionOptions;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Set;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncAction
implements BuildAction<SyncProjectModels>,
Serializable {
    @NotNull
    private final Set<Class<?>> myExtraAndroidModelTypes;
    @NotNull
    private final Set<Class<?>> myExtraJavaModelTypes;
    @NotNull
    private final SyncActionOptions myOptions;
    @NotNull
    private final SyncProjectModels.Factory myModelsFactory;

    public SyncAction(@NotNull Set<Class<?>> extraAndroidModelTypes, @NotNull Set<Class<?>> extraJavaModelTypes, @NotNull SyncActionOptions options) {
        this(extraAndroidModelTypes, extraJavaModelTypes, options, new SyncProjectModels.Factory());
    }

    SyncAction(@NotNull Set<Class<?>> extraAndroidModelTypes, @NotNull Set<Class<?>> extraJavaModelTypes, @NotNull SyncActionOptions options, @NotNull SyncProjectModels.Factory modelsFactory) {
        this.myExtraAndroidModelTypes = extraAndroidModelTypes;
        this.myExtraJavaModelTypes = extraJavaModelTypes;
        this.myOptions = options;
        this.myModelsFactory = modelsFactory;
    }

    @Nullable
    public SyncProjectModels execute(@NotNull BuildController controller) {
        SyncProjectModels models = this.myModelsFactory.create(this.myExtraAndroidModelTypes, this.myExtraJavaModelTypes, this.myOptions);
        models.populate(controller);
        return models;
    }

    @VisibleForTesting
    @NotNull
    Set<Class<?>> getExtraAndroidModelTypes() {
        return this.myExtraAndroidModelTypes;
    }

    @VisibleForTesting
    @NotNull
    Set<Class<?>> getExtraJavaModelTypes() {
        return this.myExtraJavaModelTypes;
    }

    @VisibleForTesting
    @NotNull
    SyncActionOptions getOptions() {
        return this.myOptions;
    }
}

