/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.Projects;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.build.output.AndroidGradleSyncTextConsoleView;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.SimulatedSyncErrors;
import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandlerManager;
import com.android.tools.idea.gradle.project.sync.idea.IdeaGradleSync;
import com.android.tools.idea.gradle.project.sync.ng.ExtraGradleSyncModelsManager;
import com.android.tools.idea.gradle.project.sync.ng.GradleSyncProgress;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSync;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSyncNotSupportedException;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariantCollector;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariants;
import com.android.tools.idea.gradle.project.sync.ng.SyncAction;
import com.android.tools.idea.gradle.project.sync.ng.SyncActionOptions;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutionCallback;
import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncResultHandler;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlyProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlySyncAction;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlySyncOptions;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.tracer.Trace;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.output.BuildOutputInstantReaderImpl;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.UnsupportedVersionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

class SyncExecutor {
    @NotNull
    private final Project myProject;
    @NotNull
    private final CommandLineArgs myCommandLineArgs;
    @NotNull
    private final SyncErrorHandlerManager myErrorHandlerManager;
    @NotNull
    private final ExtraGradleSyncModelsManager myExtraModelsManager;
    @NotNull
    private final SelectedVariantCollector mySelectedVariantCollector;
    @NotNull
    private final GradleExecutionHelper myHelper = new GradleExecutionHelper();

    SyncExecutor(@NotNull Project project) {
        this(project, ExtraGradleSyncModelsManager.getInstance(), new CommandLineArgs(true), new SyncErrorHandlerManager(project), new SelectedVariantCollector(project));
    }

    @VisibleForTesting
    SyncExecutor(@NotNull Project project, @NotNull ExtraGradleSyncModelsManager extraModelsManager, @NotNull CommandLineArgs commandLineArgs, @NotNull SyncErrorHandlerManager errorHandlerManager, @NotNull SelectedVariantCollector selectedVariantCollector) {
        this.myProject = project;
        this.myCommandLineArgs = commandLineArgs;
        this.myErrorHandlerManager = errorHandlerManager;
        this.myExtraModelsManager = extraModelsManager;
        this.mySelectedVariantCollector = selectedVariantCollector;
    }

    @NotNull
    List<SyncModuleModels> fetchGradleModels(ProgressIndicator indicator) {
        GradleExecutionSettings executionSettings = this.findGradleExecutionSettings();
        Function syncFunction = connection -> this.doFetchModels((ProjectConnection)connection, executionSettings, indicator, SyncExecutor.createId(this.myProject), null, true);
        SyncProjectModels models = (SyncProjectModels)this.myHelper.execute(Projects.getBaseDirPath((Project)this.myProject).getPath(), executionSettings, syncFunction);
        return models.getModuleModels();
    }

    void syncProject(@NotNull ProgressIndicator indicator, @NotNull SyncExecutionCallback callback2) {
        this.syncProject(indicator, callback2, null, null, null, null, false);
    }

    void syncProject(@NotNull ProgressIndicator indicator, @NotNull SyncExecutionCallback callback2, @NotNull VariantOnlySyncOptions options) {
        this.syncProject(indicator, callback2, options, null, null, null, options.myShouldGenerateSources);
    }

    void syncProject(@NotNull ProgressIndicator indicator, @NotNull SyncExecutionCallback callback2, @Nullable VariantOnlySyncOptions options, @Nullable GradleSyncListener listener2, @Nullable GradleSyncInvoker.Request request, @Nullable SyncResultHandler resultHandler, boolean shouldGenerateSources) {
        if (this.myProject.isDisposed()) {
            callback2.reject(String.format("Project '%1$s' is already disposed", this.myProject.getName()));
        }
        try {
            IdeaGradleSync.createGradleProjectSettingsIfNotExist(this.myProject);
            GradleExecutionSettings executionSettings = this.findGradleExecutionSettings();
            Function syncFunction = connection -> {
                this.syncProject((ProjectConnection)connection, executionSettings, indicator, callback2, options, listener2, request, resultHandler, shouldGenerateSources);
                return null;
            };
            this.myHelper.execute(Projects.getBaseDirPath((Project)this.myProject).getPath(), executionSettings, syncFunction);
        }
        catch (Throwable e) {
            callback2.setRejected(e);
        }
    }

    @NotNull
    private GradleExecutionSettings findGradleExecutionSettings() {
        GradleExecutionSettings executionSettings = GradleUtil.getOrCreateGradleExecutionSettings(this.myProject);
        ArrayList options = new ArrayList();
        Trace.addVmArgs(options);
        executionSettings.withArguments(this.myCommandLineArgs.get(this.myProject)).withVmOptions(options);
        return executionSettings;
    }

    private void syncProject(@NotNull ProjectConnection connection, @NotNull GradleExecutionSettings executionSettings, @NotNull ProgressIndicator indicator, @NotNull SyncExecutionCallback callback2, @Nullable VariantOnlySyncOptions options, @Nullable GradleSyncListener listener2, @Nullable GradleSyncInvoker.Request request, @Nullable SyncResultHandler resultHandler, boolean shouldGenerateSources) {
        block21: {
            ExternalSystemTaskId id = SyncExecutor.createId(this.myProject);
            SyncViewManager syncViewManager = (SyncViewManager)ServiceManager.getService((Project)this.myProject, SyncViewManager.class);
            try (BuildOutputInstantReaderImpl buildOutputReader = new BuildOutputInstantReaderImpl((Object)id, (BuildProgressListener)syncViewManager, Collections.emptyList());){
                String projectPath = Projects.getBaseDirPath((Project)this.myProject).getPath();
                DefaultBuildDescriptor buildDescriptor = new DefaultBuildDescriptor((Object)id, this.myProject.getName(), projectPath, System.currentTimeMillis());
                StartBuildEventImpl startEvent = new StartBuildEventImpl((BuildDescriptor)buildDescriptor, "syncing...").withContentDescriptorSupplier(() -> {
                    AndroidGradleSyncTextConsoleView consoleView = new AndroidGradleSyncTextConsoleView(this.myProject);
                    return new RunContentDescriptor((ExecutionConsole)consoleView, null, consoleView.getComponent(), "Gradle Sync");
                });
                syncViewManager.onEvent((BuildEvent)startEvent);
                try {
                    boolean forceFullVariantsSync;
                    boolean bl = forceFullVariantsSync = request != null && request.forceFullVariantsSync;
                    if (CommandLineArgs.isInTestingMode()) {
                        SimulatedSyncErrors.simulateRegisteredSyncError();
                    }
                    if (shouldGenerateSources) {
                        if (options != null) {
                            SyncExecutor.executeVariantOnlySyncAndGenerateSources(connection, executionSettings, indicator, id, buildOutputReader, callback2, options);
                        } else {
                            this.executeFullSyncAndGenerateSources(connection, executionSettings, indicator, id, buildOutputReader, callback2, forceFullVariantsSync);
                        }
                        if (resultHandler != null) {
                            resultHandler.onCompoundSyncFinished(listener2);
                        }
                        break block21;
                    }
                    if (options != null) {
                        SyncExecutor.executeVariantOnlySync(connection, executionSettings, indicator, id, buildOutputReader, callback2, options);
                        break block21;
                    }
                    this.executeFullSync(connection, executionSettings, indicator, id, buildOutputReader, callback2, forceFullVariantsSync);
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof NewGradleSyncNotSupportedException) {
                        PropertiesComponent.getInstance((Project)this.myProject).setValue("not.eligible.for.single.variant.sync", true);
                        StudioFlags.SINGLE_VARIANT_SYNC_ENABLED.override(false);
                        StudioFlags.NEW_SYNC_INFRA_ENABLED.override(false);
                        GradleSyncState.getInstance(this.myProject).syncEnded();
                        this.generateFailureEvent(id);
                        GradleSyncInvoker.getInstance().requestProjectSync(this.myProject, request != null ? request : new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_SVS_NOT_SUPPORTED), listener2);
                        break block21;
                    }
                    this.myErrorHandlerManager.handleError(e);
                    callback2.setRejected(e);
                    this.generateFailureEvent(id);
                }
            }
        }
    }

    void generateFailureEvent(@NotNull ExternalSystemTaskId id) {
        if (CommandLineArgs.isInTestingMode()) {
            PostSyncProjectSetup.finishFailedSync(id, this.myProject);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> PostSyncProjectSetup.finishFailedSync(id, this.myProject));
        }
    }

    private void executeFullSync(@NotNull ProjectConnection connection, @NotNull GradleExecutionSettings executionSettings, @NotNull ProgressIndicator indicator, @NotNull ExternalSystemTaskId id, @NotNull BuildOutputInstantReaderImpl buildOutputReader, @NotNull SyncExecutionCallback callback2, boolean forceFullVariantsSync) {
        SyncProjectModels projectModels = this.doFetchModels(connection, executionSettings, indicator, id, buildOutputReader, forceFullVariantsSync);
        callback2.setDone(projectModels, id);
    }

    @NotNull
    private SyncProjectModels doFetchModels(@NotNull ProjectConnection connection, @NotNull GradleExecutionSettings executionSettings, @NotNull ProgressIndicator indicator, @NotNull ExternalSystemTaskId id, @Nullable BuildOutputInstantReaderImpl buildOutputReader, boolean forceFullVariantsSync) {
        boolean isSingleVariantSync = !forceFullVariantsSync && NewGradleSync.isSingleVariantSync(this.myProject);
        SyncAction syncAction = this.createSyncAction(false, isSingleVariantSync);
        BuildActionExecuter executor = connection.action((BuildAction)syncAction);
        GradleExecutionHelper.prepare((LongRunningOperation)executor, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)new GradleSyncNotificationListener(id, indicator, buildOutputReader), (ProjectConnection)connection);
        return (SyncProjectModels)executor.run();
    }

    private void executeFullSyncAndGenerateSources(@NotNull ProjectConnection connection, @NotNull GradleExecutionSettings executionSettings, @NotNull ProgressIndicator indicator, @NotNull ExternalSystemTaskId id, @NotNull BuildOutputInstantReaderImpl buildOutputReader, @NotNull SyncExecutionCallback callback2, boolean forceFullVariantsSync) {
        SyncAction syncAction = this.createSyncAction(true, !forceFullVariantsSync && NewGradleSync.isSingleVariantSync(this.myProject));
        BuildActionExecuter executor = connection.action().projectsLoaded((BuildAction)syncAction, models -> callback2.setDone((SyncProjectModels)models, id)).build().forTasks(Collections.emptyList());
        GradleExecutionHelper.prepare((LongRunningOperation)executor, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)new GradleSyncNotificationListener(id, indicator, buildOutputReader), (ProjectConnection)connection);
        try {
            executor.run();
        }
        catch (UnsupportedVersionException e) {
            if (e.getMessage().contains("PhasedBuildActionExecuter API")) {
                this.executeFullSync(connection, executionSettings, indicator, id, buildOutputReader, callback2, forceFullVariantsSync);
            }
            throw e;
        }
    }

    private static void executeVariantOnlySync(@NotNull ProjectConnection connection, @NotNull GradleExecutionSettings executionSettings, @NotNull ProgressIndicator indicator, @NotNull ExternalSystemTaskId id, @NotNull BuildOutputInstantReaderImpl buildOutputReader, @NotNull SyncExecutionCallback callback2, @NotNull VariantOnlySyncOptions options) {
        VariantOnlySyncAction syncAction = new VariantOnlySyncAction(options);
        BuildActionExecuter executor = connection.action((BuildAction)syncAction);
        GradleExecutionHelper.prepare((LongRunningOperation)executor, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)new GradleSyncNotificationListener(id, indicator, buildOutputReader), (ProjectConnection)connection);
        callback2.setDone((VariantOnlyProjectModels)executor.run(), id);
    }

    private static void executeVariantOnlySyncAndGenerateSources(@NotNull ProjectConnection connection, @NotNull GradleExecutionSettings executionSettings, @NotNull ProgressIndicator indicator, @NotNull ExternalSystemTaskId id, @NotNull BuildOutputInstantReaderImpl buildOutputReader, @NotNull SyncExecutionCallback callback2, @NotNull VariantOnlySyncOptions options) {
        VariantOnlySyncAction syncAction = new VariantOnlySyncAction(options);
        BuildActionExecuter executor = connection.action().projectsLoaded((BuildAction)syncAction, models -> callback2.setDone((VariantOnlyProjectModels)models, id)).build().forTasks(Collections.emptyList());
        GradleExecutionHelper.prepare((LongRunningOperation)executor, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)new GradleSyncNotificationListener(id, indicator, buildOutputReader), (ProjectConnection)connection);
        try {
            executor.run();
        }
        catch (UnsupportedVersionException e) {
            if (e.getMessage().contains("PhasedBuildActionExecuter API")) {
                SyncExecutor.executeVariantOnlySync(connection, executionSettings, indicator, id, buildOutputReader, callback2, options);
            }
            throw e;
        }
    }

    @VisibleForTesting
    @NotNull
    SyncAction createSyncAction(boolean shouldGenerateSources, boolean isSingleVariantSync) {
        SyncActionOptions options = new SyncActionOptions();
        options.setSingleVariantSyncEnabled(isSingleVariantSync);
        if (options.isSingleVariantSyncEnabled()) {
            SelectedVariants selectedVariants2 = this.mySelectedVariantCollector.collectSelectedVariants();
            options.setSelectedVariants(selectedVariants2);
            options.setShouldGenerateSources(shouldGenerateSources);
        }
        return new SyncAction(this.myExtraModelsManager.getAndroidModelTypes(), this.myExtraModelsManager.getJavaModelTypes(), options);
    }

    @NotNull
    private static ExternalSystemTaskId createId(@NotNull Project project) {
        return ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)project);
    }

    @VisibleForTesting
    static class GradleSyncNotificationListener
    extends ExternalSystemTaskNotificationListenerAdapter {
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final ExternalSystemTaskId myTaskId;
        @Nullable
        private final BuildOutputInstantReaderImpl myOutputReader;

        GradleSyncNotificationListener(@NotNull ExternalSystemTaskId taskId, @NotNull ProgressIndicator indicator, @Nullable BuildOutputInstantReaderImpl outputReader) {
            this.myIndicator = indicator;
            this.myTaskId = taskId;
            this.myOutputReader = outputReader;
        }

        public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
            Project project = this.myTaskId.findProject();
            if (project == null) {
                return;
            }
            ((SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class)).onEvent((BuildEvent)new OutputBuildEventImpl((Object)id, text, stdOut));
            if (this.myOutputReader != null) {
                this.myOutputReader.append((CharSequence)text);
            }
        }

        public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
            GradleSyncProgress.notifyProgress(this.myIndicator, event.getDescription());
            if (event instanceof ExternalSystemTaskExecutionEvent) {
                Project project = this.myTaskId.findProject();
                if (project == null) {
                    return;
                }
                BuildEvent buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)((ExternalSystemTaskExecutionEvent)event));
                ((SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class)).onEvent(buildEvent);
            }
        }

        public void onEnd(@NotNull ExternalSystemTaskId id) {
            this.closeOutputReader();
        }

        public void onCancel(@NotNull ExternalSystemTaskId id) {
            super.onCancel(id);
            Project project = this.myTaskId.findProject();
            if (project != null) {
                FinishBuildEventImpl event = new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "cancelled", (EventResult)new SkippedResultImpl());
                ((SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class)).onEvent((BuildEvent)event);
            }
            this.closeOutputReader();
        }

        private void closeOutputReader() {
            if (this.myOutputReader != null) {
                this.myOutputReader.close();
            }
        }
    }
}

