/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.ModelBuilderParameter;
import com.android.builder.model.NativeAndroidProject;
import com.android.java.model.ArtifactModel;
import com.android.java.model.GradlePluginModel;
import com.android.java.model.JavaProject;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncActionOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.Model;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;

public class SyncModuleModels
implements GradleModuleModels {
    private static final long serialVersionUID = 5L;
    @NotNull
    private final BuildIdentifier myBuildId;
    @NotNull
    private final Set<Class<?>> myExtraAndroidModelTypes;
    @NotNull
    private final Set<Class<?>> myExtraJavaModelTypes;
    @NotNull
    private final SyncActionOptions myOptions;
    @NotNull
    private final Map<Class, List<Object>> myModelsByType = new HashMap<Class, List<Object>>();
    @NotNull
    private String myModuleName;

    public SyncModuleModels(@NotNull GradleProject gradleProject, @NotNull BuildIdentifier buildId2, @NotNull Set<Class<?>> extraAndroidModelTypes, @NotNull Set<Class<?>> extraJavaModelTypes, @NotNull SyncActionOptions options) {
        this.myBuildId = buildId2;
        this.myExtraAndroidModelTypes = extraAndroidModelTypes;
        this.myExtraJavaModelTypes = extraJavaModelTypes;
        this.myModuleName = gradleProject.getName();
        this.myOptions = options;
    }

    void populate(@NotNull GradleProject gradleProject, @NotNull BuildController controller) {
        this.addModel(GradleProject.class, gradleProject);
        this.findAndAddModel(gradleProject, controller, GradlePluginModel.class);
        this.findAndAddModel(gradleProject, controller, BuildScriptClasspathModel.class);
        AndroidProject androidProject = this.findParameterizedAndroidModel(gradleProject, controller, AndroidProject.class);
        if (androidProject != null) {
            this.findParameterizedAndroidModel(gradleProject, controller, NativeAndroidProject.class);
            for (Class<?> type : this.myExtraAndroidModelTypes) {
                this.findAndAddModel(gradleProject, controller, type);
            }
            return;
        }
        JavaProject javaProject = this.findAndAddModel(gradleProject, controller, JavaProject.class);
        if (javaProject != null) {
            for (Class<?> type : this.myExtraJavaModelTypes) {
                this.findAndAddModel(gradleProject, controller, type);
            }
            return;
        }
        this.findAndAddModel(gradleProject, controller, ArtifactModel.class);
    }

    @Nullable
    private <T> T findParameterizedAndroidModel(@NotNull GradleProject gradleProject, @NotNull BuildController controller, @NotNull Class<T> modelType) {
        if (this.myOptions.isSingleVariantSyncEnabled()) {
            try {
                Object androidModel = controller.getModel((Model)gradleProject, modelType, ModelBuilderParameter.class, parameter -> parameter.setShouldBuildVariant(false));
                if (androidModel != null) {
                    this.addModel(modelType, androidModel);
                    return (T)androidModel;
                }
            }
            catch (UnsupportedVersionException unsupportedVersionException) {
                // empty catch block
            }
        }
        return this.findAndAddModel(gradleProject, controller, modelType);
    }

    @Nullable
    private <T> T findAndAddModel(@NotNull GradleProject gradleProject, @NotNull BuildController controller, @NotNull Class<T> modelType) {
        Object model2 = controller.findModel((Model)gradleProject, modelType);
        if (model2 != null) {
            this.addModel(modelType, model2);
        }
        return (T)model2;
    }

    @Override
    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    public void setModuleName(@NotNull String moduleName) {
        this.myModuleName = moduleName;
    }

    @NotNull
    public BuildIdentifier getBuildId() {
        return this.myBuildId;
    }

    @Override
    @Nullable
    public <T> T findModel(@NotNull Class<T> modelType) {
        List<Object> models = this.myModelsByType.get(modelType);
        if (models == null || models.isEmpty()) {
            return null;
        }
        assert (models.size() == 1) : "More than one models available, please use findModels() instead.";
        Object model2 = models.get(0);
        assert (modelType.isInstance(model2));
        return modelType.cast(model2);
    }

    @Override
    @Nullable
    public <T> List<T> findModels(@NotNull Class<T> modelType) {
        List<Object> models = this.myModelsByType.get(modelType);
        if (models == null || models.isEmpty()) {
            return null;
        }
        return models.stream().map(model2 -> {
            assert (modelType.isInstance(model2));
            return modelType.cast(model2);
        }).collect(Collectors.toList());
    }

    public <T> void addModel(@NotNull Class<T> modelType, @NotNull T model2) {
        List models = this.myModelsByType.computeIfAbsent(modelType, k -> new ArrayList());
        models.add(model2);
    }
}

