/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.java.model.GradlePluginModel;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSyncNotSupportedException;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariantChooser;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariants;
import com.android.tools.idea.gradle.project.sync.ng.SyncActionOptions;
import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncProjectModels
implements Serializable {
    private static final long serialVersionUID = 4L;
    @NotNull
    private final Set<Class<?>> myExtraAndroidModelTypes;
    @NotNull
    private final Set<Class<?>> myExtraJavaModelTypes;
    @NotNull
    private final SyncActionOptions myOptions;
    @NotNull
    private final SelectedVariantChooser myVariantChooser;
    @NotNull
    private final List<SyncModuleModels> myModuleModels = new ArrayList<SyncModuleModels>();
    @NotNull
    private final List<GlobalLibraryMap> myGlobalLibraryMaps = new ArrayList<GlobalLibraryMap>();
    private BuildIdentifier myRootBuildId;
    private String myProjectName;

    public SyncProjectModels(@NotNull Set<Class<?>> extraAndroidModelTypes, @NotNull Set<Class<?>> extraJavaModelTypes, @NotNull SyncActionOptions options) {
        this(extraAndroidModelTypes, extraJavaModelTypes, options, new SelectedVariantChooser());
    }

    @VisibleForTesting
    SyncProjectModels(@NotNull Set<Class<?>> extraAndroidModelTypes, @NotNull Set<Class<?>> extraJavaModelTypes, @NotNull SyncActionOptions options, @NotNull SelectedVariantChooser variantChooser) {
        this.myExtraAndroidModelTypes = extraAndroidModelTypes;
        this.myExtraJavaModelTypes = extraJavaModelTypes;
        this.myOptions = options;
        this.myVariantChooser = variantChooser;
    }

    public void populate(@NotNull BuildController controller) {
        GradleProject gradleProject;
        GradleBuild rootBuild = controller.getBuildModel();
        this.myRootBuildId = rootBuild.getBuildIdentifier();
        this.myProjectName = rootBuild.getRootProject().getName();
        ArrayList<GradleBuild> gradleBuilds = new ArrayList<GradleBuild>();
        gradleBuilds.add(rootBuild);
        gradleBuilds.addAll((Collection<GradleBuild>)rootBuild.getIncludedBuilds());
        for (GradleBuild gradleBuild : gradleBuilds) {
            gradleProject = (GradleProject)controller.findModel((Model)gradleBuild.getRootProject(), GradleProject.class);
            SyncProjectModels.failIfKotlinPluginAppliedAndKotlinModelIsMissing(controller, gradleProject);
            if (gradleProject == null || !SyncProjectModels.hasBuildSrcModule(gradleProject.getProjectDirectory().getPath())) continue;
            throw new NewGradleSyncNotSupportedException("containing buildSrc module");
        }
        for (GradleBuild gradleBuild : gradleBuilds) {
            gradleProject = (GradleProject)controller.findModel((Model)gradleBuild.getRootProject(), GradleProject.class);
            this.populateModelsForModule(gradleProject, controller, gradleBuild.getBuildIdentifier());
        }
        if (this.myOptions.isSingleVariantSyncEnabled()) {
            SelectedVariants variants = this.myOptions.getSelectedVariants();
            Objects.requireNonNull(variants);
            this.myVariantChooser.chooseSelectedVariants(this.myModuleModels, controller, variants, this.myOptions.shouldGenerateSources());
        }
        this.populateGlobalLibraryMap(controller);
    }

    public static boolean hasBuildSrcModule(@NotNull String projectPath) {
        File buildSrcDir = new File(projectPath, "buildSrc");
        File buildFile = new File(buildSrcDir, "build.gradle");
        File ktsBuildFile = new File(buildSrcDir, "build.gradle.kts");
        return buildFile.isFile() || ktsBuildFile.isFile();
    }

    private static void failIfKotlinPluginAppliedAndKotlinModelIsMissing(@NotNull BuildController controller, @Nullable GradleProject gradleProject) {
        if (gradleProject == null) {
            return;
        }
        GradlePluginModel pluginModel = (GradlePluginModel)controller.findModel((Model)gradleProject, GradlePluginModel.class);
        if (pluginModel != null && SyncProjectModels.isKotlinProject(pluginModel)) {
            throw new NewGradleSyncNotSupportedException("containing Kotlin modules");
        }
        for (GradleProject child : gradleProject.getChildren()) {
            SyncProjectModels.failIfKotlinPluginAppliedAndKotlinModelIsMissing(controller, child);
        }
    }

    private static boolean isKotlinProject(@NotNull GradlePluginModel pluginModel) {
        return pluginModel.getGradlePluginList().stream().anyMatch(p -> p.startsWith("org.jetbrains.kotlin"));
    }

    private void populateModelsForModule(@Nullable GradleProject project, @NotNull BuildController controller, @NotNull BuildIdentifier buildId2) {
        if (project == null) {
            return;
        }
        SyncModuleModels models = new SyncModuleModels(project, buildId2, this.myExtraAndroidModelTypes, this.myExtraJavaModelTypes, this.myOptions);
        models.populate(project, controller);
        this.myModuleModels.add(models);
        for (GradleProject child : project.getChildren()) {
            this.populateModelsForModule(child, controller, buildId2);
        }
    }

    private void populateGlobalLibraryMap(@NotNull BuildController controller) {
        HashSet<BuildIdentifier> visitedBuildId = new HashSet<BuildIdentifier>();
        for (SyncModuleModels moduleModels : this.myModuleModels) {
            GlobalLibraryMap map2;
            AndroidProject androidProject = moduleModels.findModel(AndroidProject.class);
            BuildIdentifier buildId2 = moduleModels.getBuildId();
            if (androidProject == null || visitedBuildId.contains(buildId2) || (map2 = (GlobalLibraryMap)controller.findModel((Model)moduleModels.findModel(GradleProject.class), GlobalLibraryMap.class)) == null) continue;
            visitedBuildId.add(buildId2);
            this.myGlobalLibraryMaps.add(map2);
        }
    }

    @NotNull
    public List<SyncModuleModels> getModuleModels() {
        return ImmutableList.copyOf(this.myModuleModels);
    }

    @NotNull
    public List<GlobalLibraryMap> getGlobalLibraryMap() {
        return ImmutableList.copyOf(this.myGlobalLibraryMaps);
    }

    @NotNull
    public BuildIdentifier getRootBuildId() {
        return this.myRootBuildId;
    }

    @NotNull
    public String getProjectName() {
        return this.myProjectName;
    }

    public static class Factory
    implements Serializable {
        @NotNull
        public SyncProjectModels create(@NotNull Set<Class<?>> extraAndroidModelTypes, @NotNull Set<Class<?>> extraJavaModelTypes, @NotNull SyncActionOptions options) {
            return new SyncProjectModels(extraAndroidModelTypes, extraJavaModelTypes, options);
        }
    }
}

