/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.ng.ProjectSetup;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutionCallback;
import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.ModelNotFoundInCacheException;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlyProjectModels;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

class SyncResultHandler {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final GradleProjectInfo myProjectInfo;
    @NotNull
    private final ProjectSetup.Factory myProjectSetupFactory;
    @NotNull
    private final PostSyncProjectSetup myPostSyncProjectSetup;
    @NotNull
    private final CompoundSyncTestManager myCompoundSyncTestManager = new CompoundSyncTestManager();

    SyncResultHandler(@NotNull Project project) {
        this(project, GradleSyncState.getInstance(project), GradleProjectInfo.getInstance(project), new ProjectSetup.Factory(), PostSyncProjectSetup.getInstance(project));
    }

    @VisibleForTesting
    SyncResultHandler(@NotNull Project project, @NotNull GradleSyncState syncState, @NotNull GradleProjectInfo projectInfo, @NotNull ProjectSetup.Factory projectSetupFactory, @NotNull PostSyncProjectSetup postSyncProjectSetup) {
        this.myProject = project;
        this.mySyncState = syncState;
        this.myProjectInfo = projectInfo;
        this.myProjectSetupFactory = projectSetupFactory;
        this.myPostSyncProjectSetup = postSyncProjectSetup;
    }

    void onSyncFinished(@NotNull SyncExecutionCallback callback2, @NotNull PostSyncProjectSetup.Request setupRequest, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) {
        SyncProjectModels models = callback2.getSyncModels();
        ExternalSystemTaskId taskId = callback2.getTaskId();
        this.setUpProject(setupRequest, indicator, ProjectSetup::setUpProject, models, syncListener, taskId);
        if (models == null) {
            return;
        }
        Runnable runnable = () -> {
            boolean isTest = ApplicationManager.getApplication().isUnitTestMode();
            boolean isImportedProject = this.myProjectInfo.isImportedProject();
            if (!(!isImportedProject || isTest && GradleProjectImporter.ourSkipSetupFromTest)) {
                GradleProjects.open(this.myProject);
            }
            if (!isTest) {
                CommandProcessor.getInstance().runUndoTransparentAction(() -> this.myProject.save());
            }
            if (isImportedProject) {
                AndroidGradleProjectComponent projectComponent = AndroidGradleProjectComponent.getInstance(this.myProject);
                projectComponent.configureGradleProject();
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            ExternalSystemUtil.invokeLater((Project)this.myProject, (Runnable)runnable);
        }
    }

    private <T> void setUpProject(@NotNull PostSyncProjectSetup.Request setupRequest, @NotNull ProgressIndicator indicator, @NotNull SetupConsumer<T> setupFunc, @Nullable T models, @Nullable GradleSyncListener syncListener, @Nullable ExternalSystemTaskId taskId) {
        if (models != null) {
            try {
                if (syncListener != null) {
                    syncListener.setupStarted(this.myProject);
                }
                this.mySyncState.setupStarted();
                ProjectSetup projectSetup = this.myProjectSetupFactory.create(this.myProject);
                setupFunc.setup(projectSetup, models, indicator);
                projectSetup.commit();
                SyncIssuesReporter.getInstance().report(this.myProject);
                ExternalSystemUtil.scheduleExternalViewStructureUpdate((Project)this.myProject, (ProjectSystemId)GradleConstants.SYSTEM_ID);
                if (syncListener != null) {
                    syncListener.syncSucceeded(this.myProject);
                }
                this.runWhenProjectInitializedOnPooledThreadIfNotUnderTest(() -> this.myPostSyncProjectSetup.setUpProject(setupRequest, indicator, taskId));
            }
            catch (Throwable e) {
                this.notifyAndLogSyncError(SyncResultHandler.nullToUnknownErrorCause(SyncResultHandler.getRootCauseMessage(e)), e, syncListener);
            }
        } else {
            this.notifyAndLogSyncError("Gradle did not return any project models", null, syncListener);
        }
    }

    void onSyncSkipped(@NotNull CachedProjectModels projectModelsCache, @NotNull PostSyncProjectSetup.Request setupRequest, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener, @Nullable ExternalSystemTaskId taskId) throws ModelNotFoundInCacheException {
        if (syncListener != null) {
            syncListener.setupStarted(this.myProject);
        }
        this.mySyncState.setupStarted();
        ProjectSetup projectSetup = this.myProjectSetupFactory.create(this.myProject);
        projectSetup.setUpProject(projectModelsCache, indicator);
        projectSetup.commit();
        SyncIssuesReporter.getInstance().report(this.myProject);
        if (syncListener != null) {
            syncListener.syncSkipped(this.myProject);
        }
        this.runWhenProjectInitializedOnPooledThreadIfNotUnderTest(() -> this.myPostSyncProjectSetup.setUpProject(setupRequest, indicator, taskId));
    }

    void onSyncFailed(@NotNull SyncExecutionCallback callback2, @Nullable GradleSyncListener syncListener) {
        Throwable error = callback2.getSyncError();
        String errorMessage = error != null ? SyncResultHandler.getRootCauseMessage(error) : callback2.getError();
        errorMessage = SyncResultHandler.nullToUnknownErrorCause(errorMessage);
        this.notifyAndLogSyncError(errorMessage, error, syncListener);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myCompoundSyncTestManager.myLatch.countDown();
        }
    }

    private void notifyAndLogSyncError(@NotNull String errorMessage, @Nullable Throwable error, @Nullable GradleSyncListener syncListener) {
        if (ApplicationManager.getApplication().isUnitTestMode() && error != null) {
            System.out.println("***** sync error: " + error.getMessage());
        }
        if (syncListener != null) {
            syncListener.syncFailed(this.myProject, errorMessage);
        }
        this.mySyncState.syncFailed(errorMessage);
        if (error != null) {
            SyncResultHandler.getLog().warn("Gradle sync failed", error);
        } else {
            SyncResultHandler.logSyncFailure(errorMessage);
        }
    }

    @Nullable
    private static String getRootCauseMessage(@NotNull Throwable error) {
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)error);
        String message2 = rootCause.getMessage();
        return StringUtil.isEmpty((String)message2) ? rootCause.getClass().getName() : message2;
    }

    @NotNull
    private static String nullToUnknownErrorCause(@Nullable String errorMessage) {
        return StringUtil.isEmpty((String)errorMessage) ? "<Unknown cause>" : errorMessage;
    }

    private static void logSyncFailure(@NotNull String errorMessage) {
        SyncResultHandler.getLog().warn("Gradle sync failed: " + errorMessage);
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(SyncResultHandler.class);
    }

    void onVariantOnlySyncFinished(@NotNull SyncExecutionCallback callback2, @NotNull PostSyncProjectSetup.Request setupRequest, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) {
        VariantOnlyProjectModels models = callback2.getVariantOnlyModels();
        ExternalSystemTaskId taskId = callback2.getTaskId();
        this.setUpProject(setupRequest, indicator, ProjectSetup::setUpProject, models, syncListener, taskId);
    }

    void onCompoundSyncModels(@NotNull SyncExecutionCallback callback2, @NotNull PostSyncProjectSetup.Request setupRequest, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener, boolean variantOnlySync) {
        Runnable runnable;
        SyncProjectModels models = callback2.getSyncModels();
        if (models != null && SyncResultHandler.isCompoundSyncSupported(models)) {
            setupRequest.generateSourcesAfterSync = false;
        }
        Runnable runnable2 = runnable = variantOnlySync ? () -> this.onVariantOnlySyncFinished(callback2, setupRequest, indicator, syncListener) : () -> this.onSyncFinished(callback2, setupRequest, indicator, syncListener);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myCompoundSyncTestManager.myModelsCallback.set(runnable);
            this.myCompoundSyncTestManager.myLatch.countDown();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(runnable);
        }
    }

    void onCompoundSyncFinished(@Nullable GradleSyncListener syncListener) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                if (!this.myCompoundSyncTestManager.myLatch.await(1L, TimeUnit.MINUTES)) {
                    throw new RuntimeException("Waiting for Project Setup in Compound Sync timed out");
                }
            }
            catch (InterruptedException e) {
                this.myCompoundSyncTestManager.reset();
                throw new RuntimeException(e);
            }
            Runnable setupCallback = (Runnable)this.myCompoundSyncTestManager.myModelsCallback.get();
            if (setupCallback != null) {
                setupCallback.run();
            }
            this.myCompoundSyncTestManager.reset();
        }
        if (syncListener != null) {
            syncListener.sourceGenerationFinished(this.myProject);
        }
        this.mySyncState.sourceGenerationFinished();
    }

    private static boolean isCompoundSyncSupported(@NotNull SyncProjectModels projectModels) {
        for (SyncModuleModels moduleModels : projectModels.getModuleModels()) {
            GradleVersion pluginVersion;
            AndroidProject androidProject = moduleModels.findModel(AndroidProject.class);
            if (androidProject == null || (pluginVersion = GradleVersion.tryParseAndroidGradlePluginVersion((String)androidProject.getModelVersion())) != null && pluginVersion.isAtLeastIncludingPreviews(3, 3, 0)) continue;
            return false;
        }
        return true;
    }

    private void runWhenProjectInitializedOnPooledThreadIfNotUnderTest(@NotNull Runnable runnable) {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().executeOnPooledThread(runnable);
            } else {
                runnable.run();
            }
        });
    }

    private static class CompoundSyncTestManager {
        @NotNull
        private AtomicReference<Runnable> myModelsCallback = new AtomicReference();
        @NotNull
        private CountDownLatch myLatch = new CountDownLatch(1);

        private CompoundSyncTestManager() {
        }

        private void reset() {
            this.myModelsCallback.set(null);
            this.myLatch = new CountDownLatch(1);
        }
    }

    @FunctionalInterface
    private static interface SetupConsumer<T> {
        public void setup(ProjectSetup var1, T var2, ProgressIndicator var3);
    }
}

