/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng.caching;

import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedModuleModels
implements GradleModuleModels {
    private static final long serialVersionUID = 4L;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final Map<Class<?>, Serializable> myGradleModelsByType = new HashMap();

    CachedModuleModels(@NotNull Module module) {
        this.myModuleName = module.getName();
    }

    public void addModel(@NotNull Serializable model2) {
        this.myGradleModelsByType.put(model2.getClass(), model2);
    }

    @Override
    @Nullable
    public <T> T findModel(@NotNull Class<T> modelType) {
        Serializable model2 = this.myGradleModelsByType.get(modelType);
        if (modelType.isInstance(model2)) {
            return modelType.cast(model2);
        }
        return null;
    }

    @Override
    @Nullable
    public <T> List<T> findModels(@NotNull Class<T> modelType) {
        T model2 = this.findModel(modelType);
        return model2 == null ? null : ImmutableList.of(model2);
    }

    @Override
    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CachedModuleModels)) {
            return false;
        }
        CachedModuleModels that = (CachedModuleModels)o;
        return Objects.equals(this.myModuleName, that.myModuleName) && Objects.equals(this.myGradleModelsByType, that.myGradleModelsByType);
    }

    public int hashCode() {
        return Objects.hash(this.myModuleName, this.myGradleModelsByType);
    }

    public String toString() {
        return "GradleModuleModelsCache{myModuleName='" + this.myModuleName + '\'' + ", myGradleModelsByType=" + this.myGradleModelsByType + '}';
    }
}

