/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng.caching;

import com.android.tools.idea.gradle.project.sync.ng.caching.CachedModuleModels;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;

public class CachedProjectModels
implements Serializable {
    private static final long serialVersionUID = 2L;
    @NotNull
    private final Map<String, CachedModuleModels> myModelsByModuleName = new HashMap<String, CachedModuleModels>();
    @NotNull
    private final List<BuildParticipant> myBuildParticipants = new ArrayList<BuildParticipant>();

    @VisibleForTesting
    CachedProjectModels() {
    }

    @NotNull
    public List<BuildParticipant> getBuildParticipants() {
        return this.myBuildParticipants;
    }

    public void addBuildParticipant(@NotNull BuildParticipant buildParticipant) {
        this.myBuildParticipants.add(buildParticipant);
    }

    @NotNull
    public CachedModuleModels addModule(@NotNull Module module) {
        CachedModuleModels cache2 = new CachedModuleModels(module);
        this.myModelsByModuleName.put(module.getName(), cache2);
        return cache2;
    }

    @Nullable
    public CachedModuleModels findCacheForModule(@NotNull String moduleName) {
        return this.myModelsByModuleName.get(moduleName);
    }

    @NotNull
    public Future<?> saveToDisk(@NotNull Project project) {
        File cacheFilePath = CachedProjectModels.getCacheFilePath(project);
        return this.saveToDisk(cacheFilePath);
    }

    @NotNull
    public static File getCacheFilePath(@NotNull Project project) {
        return new File(GradleUtil.getCacheFolderRootPath(project), "gradle_models.ser");
    }

    @NotNull
    private Future<?> saveToDisk(@NotNull File path) {
        return ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                FileUtil.ensureExists((File)path.getParentFile());
            }
            catch (IOException e) {
                CachedProjectModels.getLog().warn(String.format("Failed to create folders for path '%1$s'", path.getPath()), (Throwable)e);
            }
            try (FileOutputStream fos = new FileOutputStream(path);){
                try (ObjectOutputStream oos = new ObjectOutputStream(fos);){
                    oos.writeObject(this);
                }
                catch (Throwable e) {
                    CachedProjectModels.getLog().warn(String.format("Failed to save Gradle models to path '%1$s'", path.getPath()), e);
                }
            }
            catch (Throwable e) {
                CachedProjectModels.getLog().warn(String.format("Failed to open path '%1$s'", path.getPath()), e);
            }
        });
    }

    public static void eraseDiskCache(@NotNull Project project) {
        File cache2 = CachedProjectModels.getCacheFilePath(project);
        if (cache2.exists()) {
            cache2.delete();
        }
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(CachedProjectModels.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CachedProjectModels)) {
            return false;
        }
        CachedProjectModels cache2 = (CachedProjectModels)o;
        return Objects.equals(this.myModelsByModuleName, cache2.myModelsByModuleName) && Objects.equals(this.myBuildParticipants, cache2.myBuildParticipants);
    }

    public int hashCode() {
        return Objects.hash(this.myModelsByModuleName, this.myBuildParticipants);
    }

    public String toString() {
        return "CachedProjectModels{myModelsByModuleName=" + this.myModelsByModuleName + "myBuildParticipants=" + this.myBuildParticipants + '}';
    }

    public static class Loader {
        /*
         * Loose catch block
         * Enabled aggressive exception aggregation
         */
        @Nullable
        public CachedProjectModels loadFromDisk(@NotNull Project project) {
            block32: {
                File cacheFilePath = CachedProjectModels.getCacheFilePath(project);
                if (!cacheFilePath.isFile()) break block32;
                try {
                    Throwable throwable = null;
                    try (FileInputStream fis = new FileInputStream(cacheFilePath);){
                        CachedProjectModels cachedProjectModels;
                        Throwable throwable2;
                        ObjectInputStream ois;
                        block30: {
                            block31: {
                                ois = new ObjectInputStream(fis);
                                throwable2 = null;
                                cachedProjectModels = (CachedProjectModels)ois.readObject();
                                if (ois == null) break block30;
                                if (throwable2 == null) break block31;
                                try {
                                    ois.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                break block30;
                            }
                            ois.close();
                        }
                        return cachedProjectModels;
                        catch (Throwable throwable4) {
                            try {
                                try {
                                    try {
                                        throwable2 = throwable4;
                                        throw throwable4;
                                    }
                                    catch (Throwable throwable5) {
                                        if (ois != null) {
                                            if (throwable2 != null) {
                                                try {
                                                    ois.close();
                                                }
                                                catch (Throwable throwable6) {
                                                    throwable2.addSuppressed(throwable6);
                                                }
                                            } else {
                                                ois.close();
                                            }
                                        }
                                        throw throwable5;
                                    }
                                }
                                catch (Throwable e) {
                                    CachedProjectModels.getLog().warn(String.format("Failed to load Gradle models from '%1$s'", cacheFilePath.getPath()), e);
                                }
                            }
                            catch (Throwable throwable7) {
                                throwable = throwable7;
                                throw throwable7;
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    CachedProjectModels.getLog().warn(String.format("Failed to access '%1$s' while loading Gradle models", cacheFilePath.getPath()), e);
                }
            }
            return null;
        }
    }

    public static class Factory {
        @NotNull
        public CachedProjectModels createNew() {
            return new CachedProjectModels();
        }
    }
}

