/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng.variantonly;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.ModelBuilderParameter;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeVariantAbi;
import com.android.builder.model.NativeVariantInfo;
import com.android.builder.model.Variant;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.builder.model.level2.GraphItem;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.ng.AndroidModule;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariantChooser;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlySyncOptions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariantOnlyProjectModels
implements Serializable {
    private static final long serialVersionUID = 3L;
    @NotNull
    private final Map<String, VariantOnlyModuleModel> myModuleModelsById = new HashMap<String, VariantOnlyModuleModel>();
    @NotNull
    private final Map<File, GlobalLibraryMap> myLibraryMapsByBuildId = new HashMap<File, GlobalLibraryMap>();
    @NotNull
    private final VariantOnlySyncOptions mySyncOptions;

    public VariantOnlyProjectModels(@NotNull VariantOnlySyncOptions syncOptions) {
        this.mySyncOptions = syncOptions;
    }

    public void populate(@NotNull BuildController controller) {
        this.populateModelsForModule(controller, this.mySyncOptions.myBuildId, this.mySyncOptions.myGradlePath, this.mySyncOptions.myVariantName);
        this.populateGlobalLibraryMap(controller);
    }

    private void populateModelsForModule(@NotNull BuildController controller, @NotNull File buildId2, @NotNull String gradlePath, @NotNull String variantName) {
        AndroidProject androidProject;
        String moduleId = Modules.createUniqueModuleId(buildId2, gradlePath);
        VariantOnlyModuleModel moduleModel = this.myModuleModelsById.get(moduleId);
        if (moduleModel != null && moduleModel.containsVariant(variantName)) {
            return;
        }
        if (moduleModel != null) {
            this.syncAndAddVariant(moduleModel, variantName, controller);
            return;
        }
        GradleProject gradleProject = VariantOnlyProjectModels.findGradleProject(controller, buildId2, gradlePath);
        if (gradleProject != null && (androidProject = (AndroidProject)controller.findModel((Model)gradleProject, AndroidProject.class, ModelBuilderParameter.class, parameter -> parameter.setShouldBuildVariant(false))) != null) {
            moduleModel = new VariantOnlyModuleModel(androidProject, gradleProject, moduleId, buildId2);
            this.myModuleModelsById.put(moduleId, moduleModel);
            this.syncAndAddNativeVariant(moduleModel, variantName, controller);
            Variant variant = this.syncAndAddVariant(moduleModel, variantName, controller);
            if (variant != null) {
                this.populateForDependencyModules(controller, variant);
                this.populateForFeatureModules(controller, androidProject.getDynamicFeatures(), variantName, buildId2);
            }
        }
    }

    private void populateForDependencyModules(@NotNull BuildController controller, @NotNull Variant variant) {
        AndroidArtifact artifact = variant.getMainArtifact();
        Dependencies dependencies = artifact.getDependencies();
        if (!dependencies.getLibraries().isEmpty()) {
            this.populateForDependencyModules(controller, dependencies);
        } else {
            this.populateForDependencyModules(controller, artifact.getDependencyGraphs());
        }
    }

    private void populateForDependencyModules(@NotNull BuildController controller, @NotNull DependencyGraphs dependencyGraphs) {
        for (GraphItem item : dependencyGraphs.getCompileDependencies()) {
            String address = item.getArtifactAddress();
            Matcher matcher = AndroidModule.MODULE_ARTIFACT_ADDRESS_PATTERN.matcher(address);
            if (!matcher.matches()) continue;
            String dependencyBuildId = matcher.group(1);
            String projectPath = matcher.group(2);
            String variantToSelect = matcher.group(4);
            if (projectPath == null || dependencyBuildId == null || variantToSelect == null) continue;
            this.populateModelsForModule(controller, new File(dependencyBuildId), projectPath, variantToSelect);
        }
    }

    private void populateForDependencyModules(@NotNull BuildController controller, @NotNull Dependencies dependencies) {
        for (AndroidLibrary library : dependencies.getLibraries()) {
            String projectPath = library.getProject();
            String dependencyBuildId = library.getBuildId();
            String variantToSelect = library.getProjectVariant();
            if (projectPath == null || dependencyBuildId == null || variantToSelect == null) continue;
            this.populateModelsForModule(controller, new File(dependencyBuildId), projectPath, variantToSelect);
        }
    }

    private void populateForFeatureModules(@NotNull BuildController controller, @NotNull Collection<String> features, @NotNull String variantToSelect, @NotNull File buildId2) {
        for (String feature : features) {
            this.populateModelsForModule(controller, buildId2, feature, variantToSelect);
        }
    }

    private void populateGlobalLibraryMap(@NotNull BuildController controller) {
        for (VariantOnlyModuleModel moduleModel : this.myModuleModelsById.values()) {
            GlobalLibraryMap map2;
            File buildId2 = moduleModel.getBuildId();
            if (this.myLibraryMapsByBuildId.containsKey(buildId2) || (map2 = (GlobalLibraryMap)controller.findModel((Model)moduleModel.getGradleProject(), GlobalLibraryMap.class)) == null) continue;
            this.myLibraryMapsByBuildId.put(buildId2, map2);
        }
    }

    @Nullable
    private Variant syncAndAddVariant(@NotNull VariantOnlyModuleModel moduleModel, @NotNull String variantName, @NotNull BuildController controller) {
        GradleProject gradleProject = moduleModel.getGradleProject();
        Variant variant = (Variant)controller.findModel((Model)gradleProject, Variant.class, ModelBuilderParameter.class, parameter -> {
            parameter.setVariantName(variantName);
            parameter.setShouldGenerateSources(this.mySyncOptions.myShouldGenerateSources);
        });
        if (variant != null) {
            moduleModel.addVariant(variant);
        }
        return variant;
    }

    private void syncAndAddNativeVariant(@NotNull VariantOnlyModuleModel moduleModel, @NotNull String variantName, @NotNull BuildController controller) {
        String finalAbiToSelect;
        NativeVariantAbi nativeVariantAbi;
        if (moduleModel.getNativeVariantAbi() != null) {
            return;
        }
        GradleProject gradleProject = moduleModel.getGradleProject();
        NativeAndroidProject nativeProject = (NativeAndroidProject)controller.findModel((Model)gradleProject, NativeAndroidProject.class, ModelBuilderParameter.class, parameter -> parameter.setShouldBuildVariant(false));
        if (nativeProject == null) {
            return;
        }
        String abiToSelect = this.mySyncOptions.myAbiName;
        List abiNames = ((NativeVariantInfo)nativeProject.getVariantInfos().get(variantName)).getAbiNames();
        if (abiToSelect == null || !abiNames.contains(abiToSelect)) {
            abiToSelect = SelectedVariantChooser.getDefaultOrFirstItem(abiNames, "x86");
        }
        if (abiToSelect != null && (nativeVariantAbi = (NativeVariantAbi)controller.findModel((Model)gradleProject, NativeVariantAbi.class, ModelBuilderParameter.class, arg_0 -> VariantOnlyProjectModels.lambda$syncAndAddNativeVariant$3(variantName, finalAbiToSelect = abiToSelect, arg_0))) != null) {
            String variantAbiName = variantName + "-" + finalAbiToSelect;
            moduleModel.setNativeVariantAbi(variantAbiName, nativeVariantAbi);
        }
    }

    @Nullable
    private static GradleProject findGradleProject(@NotNull BuildController controller, @NotNull File buildId2, @NotNull String gradlePath) {
        GradleProject gradleProject;
        GradleBuild rootBuild = controller.getBuildModel();
        GradleBuild gradleBuild = VariantOnlyProjectModels.findGradleBuild(rootBuild, buildId2);
        if (gradleBuild != null && (gradleProject = (GradleProject)controller.findModel((Model)gradleBuild.getRootProject(), GradleProject.class)) != null) {
            return VariantOnlyProjectModels.findGradleProject(gradleProject, gradlePath);
        }
        return null;
    }

    @Nullable
    private static GradleBuild findGradleBuild(@NotNull GradleBuild gradleBuild, @NotNull File buildId2) {
        Path projectRootDir = gradleBuild.getBuildIdentifier().getRootDir().toPath();
        try {
            if (Files.isSameFile(projectRootDir, buildId2.toPath())) {
                return gradleBuild;
            }
        }
        catch (IOException e) {
            return null;
        }
        for (GradleBuild childBuild : gradleBuild.getIncludedBuilds()) {
            GradleBuild build2 = VariantOnlyProjectModels.findGradleBuild(childBuild, buildId2);
            if (build2 == null) continue;
            return build2;
        }
        return null;
    }

    @Nullable
    private static GradleProject findGradleProject(@NotNull GradleProject gradleProject, @NotNull String gradlePath) {
        if (gradleProject.getPath().equals(gradlePath)) {
            return gradleProject;
        }
        for (GradleProject child : gradleProject.getChildren()) {
            GradleProject project = VariantOnlyProjectModels.findGradleProject(child, gradlePath);
            if (project == null) continue;
            return project;
        }
        return null;
    }

    @NotNull
    public List<GlobalLibraryMap> getGlobalLibraryMap() {
        return ImmutableList.copyOf(this.myLibraryMapsByBuildId.values());
    }

    @NotNull
    public List<VariantOnlyModuleModel> getModuleModels() {
        return ImmutableList.copyOf(this.myModuleModelsById.values());
    }

    private static /* synthetic */ void lambda$syncAndAddNativeVariant$3(String variantName, String finalAbiToSelect, ModelBuilderParameter parameter) {
        parameter.setVariantName(variantName);
        parameter.setAbiName(finalAbiToSelect);
    }

    public static class VariantOnlyModuleModel
    implements Serializable {
        @NotNull
        private final AndroidProject myAndroidProject;
        @NotNull
        private final GradleProject myGradleProject;
        @NotNull
        private final String myModuleId;
        @NotNull
        private final File myBuildId;
        @NotNull
        private final Map<String, Variant> myVariantsByName = new HashMap<String, Variant>();
        @Nullable
        private NativeVariantAbiModel myNativeVariantAbiModel;

        public VariantOnlyModuleModel(@NotNull AndroidProject androidProject, @NotNull GradleProject gradleProject, @NotNull String moduleId, @NotNull File buildId2) {
            this.myAndroidProject = androidProject;
            this.myGradleProject = gradleProject;
            this.myModuleId = moduleId;
            this.myBuildId = buildId2;
        }

        @NotNull
        public AndroidProject getAndroidProject() {
            return this.myAndroidProject;
        }

        @NotNull
        public GradleProject getGradleProject() {
            return this.myGradleProject;
        }

        @NotNull
        public String getModuleId() {
            return this.myModuleId;
        }

        @NotNull
        public File getBuildId() {
            return this.myBuildId;
        }

        @NotNull
        public List<Variant> getVariants() {
            return ImmutableList.copyOf(this.myVariantsByName.values());
        }

        private void addVariant(@NotNull Variant variant) {
            this.myVariantsByName.put(variant.getName(), variant);
        }

        public boolean containsVariant(@NotNull String variantName) {
            return this.myVariantsByName.containsKey(variantName);
        }

        public void setNativeVariantAbi(@NotNull String name, @NotNull NativeVariantAbi nativeVariantAbi) {
            this.myNativeVariantAbiModel = new NativeVariantAbiModel(name, nativeVariantAbi);
        }

        @Nullable
        public NativeVariantAbiModel getNativeVariantAbi() {
            return this.myNativeVariantAbiModel;
        }

        public static class NativeVariantAbiModel
        implements Serializable {
            @NotNull
            final String name;
            @NotNull
            public final NativeVariantAbi model;

            public NativeVariantAbiModel(@NotNull String name, @NotNull NativeVariantAbi nativeVariantAbi) {
                this.name = name;
                this.model = nativeVariantAbi;
            }
        }
    }
}

