/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng.variantonly;

import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.IdeNativeVariantAbi;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.ng.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlyProjectModels;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.android.tools.idea.gradle.project.sync.setup.module.android.AndroidVariantChangeModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.ndk.NdkVariantChangeModuleSetup;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class VariantOnlyProjectModelsSetup
extends ModuleSetup<VariantOnlyProjectModels> {
    @NotNull
    private final IdeDependenciesFactory myDependenciesFactory;
    @NotNull
    private final CachedProjectModels.Loader myModelsCacheLoader;
    @NotNull
    private final AndroidVariantChangeModuleSetup myAndroidModuleSetup;
    @NotNull
    private final NdkVariantChangeModuleSetup myNdkModuleSetup;

    public VariantOnlyProjectModelsSetup(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleSetupContext.Factory moduleSetupFactory, @NotNull IdeDependenciesFactory dependenciesFactory, @NotNull CachedProjectModels.Loader projectModelsCacheLoader, @NotNull AndroidVariantChangeModuleSetup moduleSetup, @NotNull NdkVariantChangeModuleSetup ndkModuleSetup) {
        super(project, modelsProvider, moduleSetupFactory);
        this.myModelsCacheLoader = projectModelsCacheLoader;
        this.myAndroidModuleSetup = moduleSetup;
        this.myDependenciesFactory = dependenciesFactory;
        this.myNdkModuleSetup = ndkModuleSetup;
    }

    @Override
    public void setUpModules(@NotNull VariantOnlyProjectModels projectModels, @NotNull ProgressIndicator indicator) {
        VariantOnlyProjectModelsSetup.notifyModuleConfigurationStarted(indicator);
        CachedProjectModels cache2 = this.myModelsCacheLoader.loadFromDisk(this.myProject);
        assert (cache2 != null);
        this.myDependenciesFactory.setUpGlobalLibraryMap(projectModels.getGlobalLibraryMap());
        ModuleFinder moduleFinder = ProjectStructure.getInstance(this.myProject).getModuleFinder();
        for (VariantOnlyProjectModels.VariantOnlyModuleModel moduleModel : projectModels.getModuleModels()) {
            Module module = moduleFinder.findModuleByModuleId(moduleModel.getModuleId());
            if (module == null) continue;
            this.setUpNdkModule(module, moduleModel, cache2);
            this.setUpAndroidModule(module, moduleModel, cache2);
        }
        cache2.saveToDisk(this.myProject);
    }

    private void setUpAndroidModule(@NotNull Module module, @NotNull VariantOnlyProjectModels.VariantOnlyModuleModel moduleModel, @NotNull CachedProjectModels cache2) {
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidModel != null && androidFacet != null) {
            CachedModuleModels cachedModels;
            ModuleSetupContext context = this.myModuleSetupFactory.create(module, this.myModelsProvider);
            androidModel.addVariantOnlyModuleModel(moduleModel, this.myDependenciesFactory);
            List<Variant> variants = moduleModel.getVariants();
            if (!variants.isEmpty()) {
                String variantToSelect = variants.get(0).getName();
                androidModel.setSelectedVariantName(variantToSelect);
                androidModel.syncSelectedVariantAndTestArtifact(androidFacet);
                this.myAndroidModuleSetup.setUpModule(context, androidModel);
            }
            if ((cachedModels = cache2.findCacheForModule(module.getName())) != null) {
                cachedModels.addModel(androidModel);
            }
        }
    }

    private void setUpNdkModule(@NotNull Module module, @NotNull VariantOnlyProjectModels.VariantOnlyModuleModel moduleModel, @NotNull CachedProjectModels cache2) {
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(module);
        NdkFacet ndkFacet = NdkFacet.getInstance(module);
        VariantOnlyProjectModels.VariantOnlyModuleModel.NativeVariantAbiModel variantAbi = moduleModel.getNativeVariantAbi();
        if (ndkModuleModel != null && ndkFacet != null && variantAbi != null) {
            ModuleSetupContext context = this.myModuleSetupFactory.create(module, this.myModelsProvider);
            IdeNativeVariantAbi ideVariantAbi = new IdeNativeVariantAbi(variantAbi.model);
            ndkModuleModel.addVariantOnlyModuleModel(ideVariantAbi);
            ndkModuleModel.setSelectedVariantName(variantAbi.name);
            ((NdkFacetConfiguration)ndkFacet.getConfiguration()).SELECTED_BUILD_VARIANT = variantAbi.name;
            this.myNdkModuleSetup.setUpModule(context, ndkModuleModel);
            CachedModuleModels cachedModels = cache2.findCacheForModule(module.getName());
            if (cachedModels != null) {
                cachedModels.addModel(ndkModuleModel);
            }
        }
    }
}

