/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.precheck;

import com.android.tools.idea.gradle.project.sync.SdkSync;
import com.android.tools.idea.gradle.project.sync.precheck.AndroidStudioSyncCheck;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

class AndroidSdkPreSyncCheck
extends AndroidStudioSyncCheck {
    @NotNull
    private final SdkSync mySdkSync;

    AndroidSdkPreSyncCheck() {
        this(SdkSync.getInstance());
    }

    @VisibleForTesting
    AndroidSdkPreSyncCheck(@NotNull SdkSync sdkSync) {
        this.mySdkSync = sdkSync;
    }

    @Override
    @NotNull
    PreSyncCheckResult checkCanSyncAndTryToFix(@NotNull Project project) {
        return this.doCheckCanSyncAndTryToFix(project);
    }

    @Override
    @NotNull
    PreSyncCheckResult doCheckCanSyncAndTryToFix(@NotNull Project project) {
        try {
            this.mySdkSync.syncIdeAndProjectAndroidSdks(project);
            return PreSyncCheckResult.SUCCESS;
        }
        catch (Throwable e) {
            String msg = "Failed to sync SDKs";
            return PreSyncCheckResult.failure(msg);
        }
    }
}

