/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.precheck;

import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.RemoveSHA256FromGradleWrapperHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.precheck.AndroidStudioSyncCheck;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class GradleWrapperPreSyncCheck
extends AndroidStudioSyncCheck {
    @Override
    @NotNull
    PreSyncCheckResult doCheckCanSyncAndTryToFix(@NotNull Project project) {
        GradleWrapper gradleWrapper = GradleWrapper.find(project);
        if (gradleWrapper != null) {
            File propertiesFilePath = gradleWrapper.getPropertiesFilePath();
            try {
                if (gradleWrapper.getProperties().getProperty("distributionSha256Sum") != null) {
                    String fileName = propertiesFilePath.getName();
                    String errorMessage = "It is not supported to define distributionSha256Sum in " + fileName + ".\nPlease manually remove this property from all of included projects if applicable.\nFor more details, see https://github.com/gradle/gradle/issues/9361.\n";
                    SyncMessage syncMessage = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, errorMessage);
                    syncMessage.add(new RemoveSHA256FromGradleWrapperHyperlink());
                    syncMessage.add(new OpenFileHyperlink(propertiesFilePath.getAbsolutePath(), "Open Gradle wrapper properties", -1, -1));
                    GradleSyncMessages.getInstance(project).report(syncMessage);
                    SyncIssueUsageReporter.Companion.getInstance(project).collect(AndroidStudioEvent.GradleSyncFailure.DISTRIBUTIONSHA256SUM_FOUND_IN_WRAPPER);
                    return PreSyncCheckResult.failure("Error in " + fileName);
                }
            }
            catch (IOException e) {
                Logger.getInstance(this.getClass()).warn("Unsupported property distributionSha256Sum in " + propertiesFilePath.getPath());
            }
        }
        return PreSyncCheckResult.SUCCESS;
    }
}

