/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.precheck;

import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.precheck.AndroidStudioSyncCheck;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class JdkPreSyncCheck
extends AndroidStudioSyncCheck {
    JdkPreSyncCheck() {
    }

    @Override
    @NotNull
    PreSyncCheckResult doCheckCanSyncAndTryToFix(@NotNull Project project) {
        String errorMessage = JdkPreSyncCheck.getErrorMessage(IdeSdks.getInstance().getJdk());
        if (errorMessage != null) {
            SyncMessage syncMessage = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, errorMessage);
            List<NotificationHyperlink> quickFixes = Jdks.getInstance().getWrongJdkQuickFixes(project);
            syncMessage.add(quickFixes);
            GradleSyncMessages.getInstance(project).report(syncMessage);
            return PreSyncCheckResult.failure("Invalid Jdk");
        }
        return PreSyncCheckResult.SUCCESS;
    }

    private static String getErrorMessage(Sdk jdk) {
        if (jdk == null) {
            return "Jdk location is not set.";
        }
        String jdkHomePath = jdk.getHomePath();
        if (jdkHomePath == null) {
            return "Could not find valid Jdk home from the selected Jdk location.";
        }
        String selectedJdkMsg = "Selected Jdk location is " + jdkHomePath + ".\n";
        JavaSdkVersion runningJdkVersion = IdeSdks.getInstance().getRunningVersionOrDefault();
        if (!IdeSdks.isJdkSameVersion(new File(jdkHomePath), runningJdkVersion)) {
            return "The version of selected Jdk doesn't match the Jdk used by Studio. Please choose a valid Jdk " + runningJdkVersion.getDescription() + " directory.\n" + selectedJdkMsg;
        }
        if (!JdkUtil.checkForJdk((String)jdkHomePath)) {
            return "The Jdk installation is invalid.\n" + selectedJdkMsg;
        }
        if (!Jdks.isJdkRunnableOnPlatform(jdk)) {
            return "The selected Jdk could not run on current OS.\nIf you are using embedded Jdk, please make sure to download Android Studio bundle compatible\nwith the current OS. For example, for x86 systems please choose a 32 bits download option.\n" + selectedJdkMsg;
        }
        return null;
    }
}

