/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.precheck;

import com.android.tools.idea.gradle.project.sync.precheck.AndroidSdkPreSyncCheck;
import com.android.tools.idea.gradle.project.sync.precheck.GradleWrapperPreSyncCheck;
import com.android.tools.idea.gradle.project.sync.precheck.JdkPreSyncCheck;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.android.tools.idea.gradle.project.sync.precheck.SyncCheck;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PreSyncChecks {
    @NotNull
    private final List<SyncCheck> myStrategies;

    @NotNull
    public static PreSyncChecks getInstance() {
        return (PreSyncChecks)ServiceManager.getService(PreSyncChecks.class);
    }

    public PreSyncChecks() {
        this(new AndroidSdkPreSyncCheck(), new JdkPreSyncCheck(), new GradleWrapperPreSyncCheck());
    }

    @VisibleForTesting
    PreSyncChecks(SyncCheck ... strategies) {
        this.myStrategies = Lists.newArrayList((Object[])strategies);
    }

    @NotNull
    public PreSyncCheckResult canSyncAndTryToFix(@NotNull Project project) {
        for (SyncCheck condition : this.myStrategies) {
            PreSyncCheckResult result2 = condition.checkCanSyncAndTryToFix(project);
            if (result2.isSuccess()) continue;
            return result2;
        }
        return PreSyncCheckResult.SUCCESS;
    }

    @VisibleForTesting
    @NotNull
    List<SyncCheck> getStrategies() {
        return this.myStrategies;
    }
}

