/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.java.model.GradlePluginModel;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetType;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.GradleSyncSummary;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleModuleSetup {
    @NotNull
    public GradleModuleModel setUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull GradleModuleModels models) {
        GradleModuleModel gradleModuleModel = GradleModuleSetup.createGradleModel(module, models);
        this.setUpModule(module, ideModelsProvider, gradleModuleModel);
        return gradleModuleModel;
    }

    @NotNull
    private static GradleModuleModel createGradleModel(@NotNull Module module, @NotNull GradleModuleModels models) {
        GradleProject gradleProject = models.findModel(GradleProject.class);
        assert (gradleProject != null);
        GradleScript buildScript = null;
        try {
            buildScript = gradleProject.getBuildScript();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        File buildFilePath = buildScript != null ? buildScript.getSourceFile() : null;
        AndroidProject androidProject = models.findModel(AndroidProject.class);
        String agpVersion = androidProject != null ? androidProject.getModelVersion() : null;
        return new GradleModuleModel(module.getName(), gradleProject, GradleModuleSetup.getGradlePlugins(models), buildFilePath, GradleModuleSetup.getGradleVersion(module), agpVersion);
    }

    @NotNull
    private static Collection<String> getGradlePlugins(@NotNull GradleModuleModels models) {
        GradlePluginModel pluginModel = models.findModel(GradlePluginModel.class);
        return pluginModel == null ? Collections.emptyList() : pluginModel.getGradlePluginList();
    }

    public void setUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull GradleModuleModel model2) {
        GradleFacet facet = Facets.findFacet(module, ideModelsProvider, GradleFacet.getFacetTypeId());
        if (facet == null) {
            ModifiableFacetModel facetModel = ideModelsProvider.getModifiableFacetModel(module);
            GradleFacetType facetType = GradleFacet.getFacetType();
            facet = facetType.createFacet(module, GradleFacet.getFacetName(), facetType.createDefaultConfiguration(), (Facet)null);
            facetModel.addFacet((Facet)facet);
        }
        facet.setGradleModuleModel(model2);
        String gradleVersion2 = model2.getGradleVersion();
        GradleSyncSummary syncReport = GradleSyncState.getInstance(module.getProject()).getSummary();
        if (StringUtil.isNotEmpty((String)gradleVersion2) && syncReport.getGradleVersion() == null) {
            syncReport.setGradleVersion(GradleVersion.parse((String)gradleVersion2));
        }
    }

    @Nullable
    private static String getGradleVersion(@NotNull Module module) {
        GradleWrapper gradleWrapper = GradleWrapper.find(module.getProject());
        if (gradleWrapper != null) {
            try {
                return gradleWrapper.getGradleFullVersion();
            }
            catch (IOException ignore) {
                return null;
            }
        }
        return null;
    }
}

