/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.setup.post.project.DisposedModules;
import com.android.tools.idea.io.FilePaths;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ModuleDisposer {
    @NotNull
    private final IdeInfo myIdeInfo;

    public ModuleDisposer() {
        this(IdeInfo.getInstance());
    }

    @VisibleForTesting
    ModuleDisposer(@NotNull IdeInfo ideInfo) {
        this.myIdeInfo = ideInfo;
    }

    public void disposeModules(@NotNull Collection<Module> modules, @NotNull Project project, @NotNull IdeModifiableModelsProvider ideModelsProvider) {
        if (!modules.isEmpty()) {
            ModifiableModuleModel moduleModel = ideModelsProvider.getModifiableModuleModel();
            ArrayList<File> imlFilesToRemove = new ArrayList<File>();
            for (Module toDispose : modules) {
                File imlFilePath = FilePaths.toSystemDependentPath((String)toDispose.getModuleFilePath());
                imlFilesToRemove.add(imlFilePath);
                moduleModel.disposeModule(toDispose);
            }
            DisposedModules.getInstance(project).markImlFilesForDeletion(imlFilesToRemove);
        }
    }

    public boolean canDisposeModules(@NotNull Project project) {
        return this.myIdeInfo.isAndroidStudio() && !GradleSyncState.getInstance(project).lastSyncFailedOrHasIssues();
    }
}

