/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module;

import com.android.builder.model.level2.Library;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.google.common.base.Strings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class ModuleFinder {
    @NotNull
    public static final ModuleFinder EMPTY = new ModuleFinder();
    @NotNull
    private final Map<String, Module> myModulesByGradlePath = new HashMap<String, Module>();
    @NotNull
    private final Map<String, Module> myModulesByModuleId = new HashMap<String, Module>();
    @NotNull
    private final Map<String, File> myIncludedProjectFolderByModuleFolder = new HashMap<String, File>();

    private ModuleFinder() {
    }

    public ModuleFinder(@NotNull Project project) {
        this.populateIncludedProjectFolderByModuleFolder(project);
    }

    private void populateIncludedProjectFolderByModuleFolder(@NotNull Project project) {
        String projectPath = project.getBasePath();
        if (projectPath == null) {
            return;
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(projectPath);
        if (projectSettings == null) {
            return;
        }
        GradleProjectSettings.CompositeBuild compositeBuild = projectSettings.getCompositeBuild();
        if (compositeBuild == null) {
            return;
        }
        for (BuildParticipant participant : compositeBuild.getCompositeParticipants()) {
            for (String modulePath : participant.getProjects()) {
                String path = Strings.nullToEmpty((String)participant.getRootPath());
                this.myIncludedProjectFolderByModuleFolder.put(modulePath, new File(path));
            }
        }
    }

    public void addModule(@NotNull Module module, @NotNull String gradlePath) {
        this.myModulesByGradlePath.put(gradlePath, module);
        File folderPath = this.getProjectRootFolder(module);
        if (folderPath != null) {
            this.myModulesByModuleId.put(Modules.createUniqueModuleId(folderPath, gradlePath), module);
        }
    }

    @Nullable
    private File getProjectRootFolder(@NotNull Module module) {
        String modulePath;
        File moduleFolder = GradleProjects.findModuleRootFolderPath(module);
        if (moduleFolder != null && this.myIncludedProjectFolderByModuleFolder.containsKey(modulePath = ExternalSystemApiUtil.toCanonicalPath((String)moduleFolder.getPath()))) {
            return this.myIncludedProjectFolderByModuleFolder.get(modulePath);
        }
        return Projects.getBaseDirPath((Project)module.getProject());
    }

    @Nullable
    public Module findModuleByGradlePath(@NotNull String gradlePath) {
        return this.myModulesByGradlePath.get(gradlePath);
    }

    @Nullable
    public Module findModuleByModuleId(@NotNull String moduleId) {
        return this.myModulesByModuleId.get(moduleId);
    }

    @Nullable
    public Module findModuleFromLibrary(@NotNull Library library) {
        if (library.getType() != 3) {
            return null;
        }
        String gradlePath = library.getProjectPath();
        if (StringUtil.isNotEmpty((String)gradlePath)) {
            Module module = null;
            String projectFolderPath = library.getBuildId();
            if (StringUtil.isNotEmpty((String)projectFolderPath)) {
                String moduleId = Modules.createUniqueModuleId(projectFolderPath, gradlePath);
                module = this.myModulesByModuleId.get(moduleId);
            }
            return module != null ? module : this.myModulesByGradlePath.get(gradlePath);
        }
        return null;
    }

    public boolean isCompositeBuild(@NotNull Module module) {
        File moduleFolder = GradleProjects.findModuleRootFolderPath(module);
        if (moduleFolder != null) {
            return this.myIncludedProjectFolderByModuleFolder.containsKey(ExternalSystemApiUtil.toCanonicalPath((String)moduleFolder.getPath()));
        }
        return false;
    }

    @NotNull
    public Path getRootProjectPath(@NotNull Module module) {
        String canonicalPath;
        File moduleFolder = GradleProjects.findModuleRootFolderPath(module);
        if (moduleFolder != null && this.myIncludedProjectFolderByModuleFolder.containsKey(canonicalPath = ExternalSystemApiUtil.toCanonicalPath((String)moduleFolder.getPath()))) {
            return this.myIncludedProjectFolderByModuleFolder.get(canonicalPath).toPath();
        }
        return Projects.getBaseDirPath((Project)module.getProject()).toPath();
    }

    public String toString() {
        return "ModuleFinder{myModulesByGradlePath=" + this.myModulesByGradlePath + ", myModulesByModuleId=" + this.myModulesByModuleId + ", myIncludedProjectFolderByModuleFolder=" + this.myIncludedProjectFolderByModuleFolder + '}';
    }

    public static class Factory {
        @NotNull
        public ModuleFinder create(@NotNull Project project) {
            return new ModuleFinder(project);
        }
    }
}

