/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.common.ContentEntriesSetup;
import com.android.tools.idea.gradle.util.ContentEntries;
import com.android.tools.idea.gradle.util.GeneratedSourceFolders;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

class AndroidContentEntriesSetup
extends ContentEntriesSetup {
    @NotNull
    private final AndroidModuleModel myAndroidModel;
    @NotNull
    private final GeneratedSourceFolders myGeneratedSourceFolders;
    private final boolean myHasNativeModel;

    private AndroidContentEntriesSetup(@NotNull AndroidModuleModel androidModel, @NotNull ModifiableRootModel moduleModel, boolean hasNativeModel) {
        super(moduleModel);
        this.myAndroidModel = androidModel;
        this.myHasNativeModel = hasNativeModel;
        this.myGeneratedSourceFolders = new GeneratedSourceFolders();
    }

    @Override
    public void execute(@NotNull List<ContentEntry> contentEntries) {
        IdeVariant selectedVariant = this.myAndroidModel.getSelectedVariant();
        IdeAndroidArtifact mainArtifact = selectedVariant.getMainArtifact();
        this.addSourceFolders((IdeBaseArtifact)mainArtifact, contentEntries, false);
        for (IdeBaseArtifact artifact : selectedVariant.getTestArtifacts()) {
            this.addSourceFolders(artifact, contentEntries, true);
        }
        for (String flavorName : selectedVariant.getProductFlavors()) {
            ProductFlavorContainer flavor = this.myAndroidModel.findProductFlavor(flavorName);
            if (flavor == null) continue;
            this.addSourceFolder(flavor, contentEntries);
        }
        String buildTypeName = selectedVariant.getBuildType();
        BuildTypeContainer buildTypeContainer = this.myAndroidModel.findBuildType(buildTypeName);
        if (buildTypeContainer != null) {
            this.addSourceFolder(buildTypeContainer.getSourceProvider(), contentEntries, false);
            Collection<SourceProvider> testSourceProviders = this.myAndroidModel.getTestSourceProviders(buildTypeContainer.getExtraSourceProviders());
            for (SourceProvider testSourceProvider : testSourceProviders) {
                this.addSourceFolder(testSourceProvider, contentEntries, true);
            }
        }
        ProductFlavorContainer defaultConfig = this.getAndroidProject().getDefaultConfig();
        this.addSourceFolder(defaultConfig, contentEntries);
        this.addExcludedOutputFolders(contentEntries);
        this.addOrphans();
    }

    private void addSourceFolders(@NotNull IdeBaseArtifact artifact, @NotNull List<ContentEntry> contentEntries, boolean isTest) {
        SourceProvider multiFlavorSourceProvider;
        this.addGeneratedSourceFolders(artifact, contentEntries, isTest);
        SourceProvider variantSourceProvider = artifact.getVariantSourceProvider();
        if (variantSourceProvider != null) {
            this.addSourceFolder(variantSourceProvider, contentEntries, isTest);
        }
        if ((multiFlavorSourceProvider = artifact.getMultiFlavorSourceProvider()) != null) {
            this.addSourceFolder(multiFlavorSourceProvider, contentEntries, isTest);
        }
    }

    private void addGeneratedSourceFolders(@NotNull IdeBaseArtifact artifact, @NotNull List<ContentEntry> contentEntries, boolean isTest) {
        JpsModuleSourceRootType sourceType = AndroidContentEntriesSetup.getSourceType(isTest);
        GradleVersion modelVersion = this.myAndroidModel.getModelVersion();
        if (artifact instanceof AndroidArtifact || modelVersion != null && modelVersion.compareIgnoringQualifiers("1.2") >= 0) {
            this.addSourceFolders(GradleUtil.getGeneratedSourceFoldersToUse(artifact, this.myAndroidModel), contentEntries, sourceType, true);
        }
        if (artifact instanceof AndroidArtifact) {
            sourceType = AndroidContentEntriesSetup.getResourceSourceType(isTest);
            AndroidArtifact androidArtifact = (AndroidArtifact)artifact;
            this.addSourceFolders(androidArtifact.getGeneratedResourceFolders(), contentEntries, sourceType, true);
        }
    }

    private void addSourceFolder(@NotNull ProductFlavorContainer flavor, @NotNull List<ContentEntry> contentEntries) {
        this.addSourceFolder(flavor.getSourceProvider(), contentEntries, false);
        Collection<SourceProvider> testSourceProviders = this.myAndroidModel.getTestSourceProviders(flavor.getExtraSourceProviders());
        for (SourceProvider sourceProvider : testSourceProviders) {
            this.addSourceFolder(sourceProvider, contentEntries, true);
        }
    }

    private void addSourceFolder(@NotNull SourceProvider sourceProvider, @NotNull List<ContentEntry> contentEntries, boolean isTest) {
        JpsModuleSourceRootType sourceType = AndroidContentEntriesSetup.getResourceSourceType(isTest);
        this.addSourceFolders(sourceProvider.getResDirectories(), contentEntries, sourceType, false);
        this.addSourceFolders(sourceProvider.getResourcesDirectories(), contentEntries, sourceType, false);
        this.addSourceFolders(sourceProvider.getAssetsDirectories(), contentEntries, sourceType, false);
        sourceType = AndroidContentEntriesSetup.getSourceType(isTest);
        this.addSourceFolders(sourceProvider.getAidlDirectories(), contentEntries, sourceType, false);
        this.addSourceFolders(sourceProvider.getJavaDirectories(), contentEntries, sourceType, false);
        if (this.myHasNativeModel) {
            this.addSourceFolders(sourceProvider.getCDirectories(), contentEntries, sourceType, false);
            this.addSourceFolders(sourceProvider.getCppDirectories(), contentEntries, sourceType, false);
        }
        this.addSourceFolders(sourceProvider.getRenderscriptDirectories(), contentEntries, sourceType, false);
        if (this.myAndroidModel.getFeatures().isShadersSupported()) {
            this.addSourceFolders(sourceProvider.getShadersDirectories(), contentEntries, sourceType, false);
        }
    }

    @NotNull
    private static JpsModuleSourceRootType getResourceSourceType(boolean isTest) {
        return isTest ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE;
    }

    @NotNull
    private static JpsModuleSourceRootType getSourceType(boolean isTest) {
        return isTest ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
    }

    private void addSourceFolders(@NotNull Collection<File> folderPaths, @NotNull List<ContentEntry> contentEntries, @NotNull JpsModuleSourceRootType type, boolean generated) {
        for (File folderPath : folderPaths) {
            if (generated && !this.myGeneratedSourceFolders.isFolderGeneratedInCorrectLocation(folderPath, this.getAndroidProject())) {
                this.myAndroidModel.registerExtraGeneratedSourceFolder(folderPath);
            }
            this.addSourceFolder(folderPath, contentEntries, type, generated);
        }
    }

    private void addExcludedOutputFolders(@NotNull List<ContentEntry> contentEntries) {
        File buildFolderPath = this.getAndroidProject().getBuildFolder();
        ContentEntry parentContentEntry = ContentEntries.findParentContentEntry(buildFolderPath, contentEntries.stream());
        if (parentContentEntry != null) {
            this.addExcludedFolder(parentContentEntry, buildFolderPath);
        }
    }

    @NotNull
    private AndroidProject getAndroidProject() {
        return this.myAndroidModel.getAndroidProject();
    }

    static class Factory {
        Factory() {
        }

        @NotNull
        AndroidContentEntriesSetup create(@NotNull AndroidModuleModel androidModel, @NotNull ModifiableRootModel moduleModel, boolean hasNativeModel) {
            return new AndroidContentEntriesSetup(androidModel, moduleModel, hasNativeModel);
        }
    }
}

