/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetupStep;
import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidFacetModuleSetupStep
extends AndroidModuleSetupStep {
    private static final String SEPARATOR = "/";

    @Override
    protected void doSetUpModule(@NotNull ModuleSetupContext context, @NotNull AndroidModuleModel androidModel) {
        IdeModifiableModelsProvider ideModelsProvider;
        Module module = context.getModule();
        AndroidFacet facet = AndroidFacet.getInstance(module, ideModelsProvider = context.getIdeModelsProvider());
        if (facet == null) {
            facet = AndroidFacetModuleSetupStep.createAndAddFacet(module, ideModelsProvider);
        }
        AndroidFacetModuleSetupStep.configureFacet(facet, androidModel);
    }

    @NotNull
    private static AndroidFacet createAndAddFacet(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider) {
        ModifiableFacetModel model2 = ideModelsProvider.getModifiableFacetModel(module);
        AndroidFacetType facetType = AndroidFacet.getFacetType();
        AndroidFacet facet = facetType.createFacet(module, "Android", facetType.createDefaultConfiguration(), (Facet)null);
        model2.addFacet((Facet)facet);
        return facet;
    }

    private static void configureFacet(@NotNull AndroidFacet facet, @NotNull AndroidModuleModel androidModel) {
        JpsAndroidModuleProperties facetProperties = facet.getProperties();
        facetProperties.ALLOW_USER_CONFIGURATION = false;
        facetProperties.PROJECT_TYPE = androidModel.getAndroidProject().getProjectType();
        File modulePath = androidModel.getRootDirPath();
        SourceProvider sourceProvider = androidModel.getDefaultSourceProvider();
        facetProperties.MANIFEST_FILE_RELATIVE_PATH = AndroidFacetModuleSetupStep.relativePath(modulePath, sourceProvider.getManifestFile());
        facetProperties.RES_FOLDER_RELATIVE_PATH = AndroidFacetModuleSetupStep.relativePath(modulePath, sourceProvider.getResDirectories());
        facetProperties.ASSETS_FOLDER_RELATIVE_PATH = AndroidFacetModuleSetupStep.relativePath(modulePath, sourceProvider.getAssetsDirectories());
        AndroidFacetModuleSetupStep.syncSelectedVariant(facetProperties, androidModel);
        ((AndroidFacetConfiguration)facet.getConfiguration()).setModel(androidModel);
        androidModel.syncSelectedVariantAndTestArtifact(facet);
    }

    private static void syncSelectedVariant(@NotNull JpsAndroidModuleProperties facetProperties, @NotNull AndroidModuleModel androidModel) {
        String variantStoredInFacet = facetProperties.SELECTED_BUILD_VARIANT;
        if (StringUtil.isNotEmpty((String)variantStoredInFacet) && androidModel.getVariantNames().contains(variantStoredInFacet)) {
            androidModel.setSelectedVariantName(variantStoredInFacet);
        }
    }

    @NotNull
    private static String relativePath(@NotNull File basePath, @NotNull Collection<File> dirs) {
        return AndroidFacetModuleSetupStep.relativePath(basePath, (File)ContainerUtil.getFirstItem(dirs));
    }

    @NotNull
    private static String relativePath(@NotNull File basePath, @Nullable File file) {
        String relativePath = null;
        if (file != null) {
            relativePath = FileUtilRt.getRelativePath((File)basePath, (File)file);
        }
        if (relativePath != null && !relativePath.startsWith(SEPARATOR)) {
            return SEPARATOR + FileUtilRt.toSystemIndependentName((String)relativePath);
        }
        return "";
    }

    @Override
    public boolean invokeOnSkippedSync() {
        return true;
    }
}

