/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.tools.idea.gradle.LibraryFilePaths;
import com.android.tools.idea.gradle.project.sync.setup.module.common.ModuleDependenciesSetup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import java.io.File;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleConstants;

class AndroidModuleDependenciesSetup
extends ModuleDependenciesSetup {
    private static final Logger LOG = Logger.getInstance(AndroidModuleDependenciesSetup.class);
    @NotNull
    private final LibraryFilePaths myLibraryFilePaths;

    AndroidModuleDependenciesSetup(@NotNull LibraryFilePaths libraryFilePaths) {
        this.myLibraryFilePaths = libraryFilePaths;
    }

    void setUpLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull String libraryName, @NotNull DependencyScope scope, @NotNull File artifactPath, boolean exported) {
        this.setUpLibraryDependency(module, modelsProvider, libraryName, scope, artifactPath, new File[]{artifactPath}, exported);
    }

    void setUpLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull String libraryName, @NotNull DependencyScope scope, @NotNull File artifactPath, @NotNull File[] binaryPaths, boolean exported) {
        String prefix = GradleConstants.SYSTEM_ID.getReadableName() + ": ";
        libraryName = libraryName.isEmpty() || StringUtil.startsWith((CharSequence)libraryName, (CharSequence)prefix) ? libraryName : prefix + libraryName;
        boolean newLibrary = false;
        Library library = modelsProvider.getLibraryByName(libraryName);
        if (library == null || !AndroidModuleDependenciesSetup.isLibraryValid(modelsProvider.getModifiableLibraryModel(library), binaryPaths)) {
            if (library != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(library.getName() + " not valid after sync.");
                }
                modelsProvider.removeLibrary(library);
            }
            library = modelsProvider.createLibrary(libraryName);
            newLibrary = true;
        }
        if (newLibrary) {
            File javadocJarPath;
            this.updateLibraryRootTypePaths(library, OrderRootType.CLASSES, modelsProvider, binaryPaths);
            File sourceJarPath = this.myLibraryFilePaths.findSourceJarPath(artifactPath);
            if (sourceJarPath != null) {
                this.updateLibraryRootTypePaths(library, OrderRootType.SOURCES, modelsProvider, sourceJarPath);
            }
            if ((javadocJarPath = this.myLibraryFilePaths.findJavadocJarPath(artifactPath)) != null) {
                this.updateLibraryRootTypePaths(library, JavadocOrderRootType.getInstance(), modelsProvider, javadocJarPath);
            }
            for (File binaryPath : binaryPaths) {
                File annotations;
                String pathName = binaryPath.getPath();
                if (pathName.endsWith("res") && pathName.length() > "res".length() && pathName.charAt(pathName.length() - "res".length() - 1) == File.separatorChar) {
                    annotations = new File(pathName.substring(0, pathName.length() - "res".length()), "annotations.zip");
                    if (!annotations.isFile()) continue;
                    this.updateLibraryRootTypePaths(library, AnnotationOrderRootType.getInstance(), modelsProvider, annotations);
                    continue;
                }
                if (!libraryName.startsWith("androidx.annotations:annotations", prefix.length()) && !libraryName.startsWith("com.android.support:support-annotations", prefix.length()) || !pathName.endsWith(".jar") || !(annotations = new File(pathName.substring(0, pathName.length() - ".jar".length()) + "-" + "annotations.zip")).isFile()) continue;
                this.updateLibraryRootTypePaths(library, AnnotationOrderRootType.getInstance(), modelsProvider, annotations);
            }
        }
        this.addLibraryAsDependency(library, libraryName, scope, module, modelsProvider, exported);
    }

    private static boolean isLibraryValid(@NotNull Library.ModifiableModel library, @NotNull File[] binaryPaths) {
        if (library.isChanged()) {
            return true;
        }
        String[] cachedUrls = library.getUrls(OrderRootType.CLASSES);
        if (cachedUrls.length != binaryPaths.length) {
            return false;
        }
        if (binaryPaths.length == 0) {
            return true;
        }
        String newUrl = VfsUtil.getUrlForLibraryRoot((File)binaryPaths[0]);
        for (String url : cachedUrls) {
            try {
                if (!Objects.equals(url, newUrl)) continue;
                return true;
            }
            catch (UncheckedIOException ignored) {
                return false;
            }
        }
        return false;
    }
}

